/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.event.DockableAdapter;
import bibliothek.gui.dock.event.DockableListener;
import bibliothek.gui.dock.station.DisplayerCollection;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.station.support.PlaceholderListItem;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleRequest;
import bibliothek.gui.dock.title.DockTitleVersion;

public class StationChildHandle
implements PlaceholderListItem {
    private DockStation station;
    private Dockable dockable;
    private DisplayerCollection displayers;
    private DockableDisplayer displayer;
    private DockTitleRequest titleRequest;
    private DockableListener listener = new DockableAdapter(){

        public void titleExchanged(Dockable dockable, DockTitle dockTitle) {
            if (dockable == StationChildHandle.this.dockable && StationChildHandle.this.displayer != null && StationChildHandle.this.displayer.getTitle() == dockTitle) {
                StationChildHandle.this.requestTitle();
            }
        }
    };

    public StationChildHandle(DockStation dockStation, DisplayerCollection displayerCollection, Dockable dockable, DockTitleVersion dockTitleVersion) {
        this.station = dockStation;
        this.displayers = displayerCollection;
        this.dockable = dockable;
        dockable.addDockableListener(this.listener);
        this.setTitleRequest(dockTitleVersion, false);
    }

    public void destroy() {
        if (this.displayer != null) {
            DockTitle dockTitle = this.displayer.getTitle();
            if (dockTitle != null) {
                this.dockable.unbind(dockTitle);
            }
            this.displayers.release(this.displayer);
            this.displayer = null;
        }
        if (this.titleRequest != null) {
            this.titleRequest.uninstall();
            this.titleRequest = null;
        }
        this.dockable.removeDockableListener(this.listener);
    }

    public void updateDisplayer() {
        DockTitle dockTitle = null;
        if (this.displayer != null) {
            dockTitle = this.displayer.getTitle();
            this.displayers.release(this.displayer);
        } else if (this.titleRequest != null) {
            this.titleRequest.request();
            dockTitle = this.titleRequest.getAnswer();
            if (dockTitle != null) {
                this.dockable.bind(dockTitle);
            }
        }
        this.displayer = this.displayers.fetch(this.dockable, dockTitle);
    }

    public DockableDisplayer getDisplayer() {
        return this.displayer;
    }

    public Dockable getDockable() {
        return this.dockable;
    }

    public Dockable asDockable() {
        return this.getDockable();
    }

    public DockTitle getTitle() {
        if (this.titleRequest == null) {
            return null;
        }
        return this.titleRequest.getAnswer();
    }

    public void setTitleRequest(DockTitleVersion dockTitleVersion) {
        this.setTitleRequest(dockTitleVersion, true);
    }

    public void setTitleRequest(DockTitleVersion dockTitleVersion, boolean bl) {
        if (this.titleRequest != null) {
            this.titleRequest.uninstall();
            this.titleRequest = null;
            DockTitle dockTitle = this.displayer.getTitle();
            if (dockTitle != null) {
                this.displayer.getDockable().unbind(dockTitle);
                this.displayer.setTitle(null);
            }
        }
        if (dockTitleVersion != null) {
            this.titleRequest = new DockTitleRequest(this.station, this.dockable, dockTitleVersion){

                protected void answer(DockTitle dockTitle, DockTitle dockTitle2) {
                    if (StationChildHandle.this.displayer != null) {
                        DockTitle dockTitle3 = StationChildHandle.this.displayer.getTitle();
                        if (dockTitle3 != null) {
                            StationChildHandle.this.dockable.unbind(dockTitle3);
                        }
                        if (dockTitle2 != null) {
                            StationChildHandle.this.dockable.bind(dockTitle2);
                        }
                        StationChildHandle.this.displayer.setTitle(dockTitle2);
                    }
                }
            };
        }
        if (this.titleRequest != null) {
            this.titleRequest.install();
            if (bl) {
                this.titleRequest.request();
            }
        }
    }

    public void requestTitle() {
        if (this.titleRequest != null) {
            this.titleRequest.request();
        }
    }
}

