/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.flap;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockFactory;
import bibliothek.gui.dock.FlapDockStation;
import bibliothek.gui.dock.layout.DockLayoutInfo;
import bibliothek.gui.dock.layout.LocationEstimationMap;
import bibliothek.gui.dock.station.flap.FlapDockProperty;
import bibliothek.gui.dock.station.flap.FlapDockStationLayout;
import bibliothek.gui.dock.station.flap.RetroFlapDockStationLayout;
import bibliothek.gui.dock.station.support.ConvertedPlaceholderListItem;
import bibliothek.gui.dock.station.support.PlaceholderList;
import bibliothek.gui.dock.station.support.PlaceholderListItem;
import bibliothek.gui.dock.station.support.PlaceholderListItemAdapter;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.util.Path;
import bibliothek.util.Version;
import bibliothek.util.xml.XAttribute;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlapDockStationFactory
implements DockFactory<FlapDockStation, FlapDockStationLayout> {
    public static final String ID = "flap dock";

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public FlapDockStationLayout getLayout(FlapDockStation flapDockStation, Map<Dockable, Integer> map) {
        PlaceholderMap placeholderMap = flapDockStation.getPlaceholders(map);
        return new FlapDockStationLayout(flapDockStation.isAutoDirection(), flapDockStation.getDirection(), placeholderMap);
    }

    @Override
    public void setLayout(FlapDockStation flapDockStation, FlapDockStationLayout flapDockStationLayout) {
        flapDockStation.setDirection(flapDockStationLayout.getDirection());
        flapDockStation.setAutoDirection(flapDockStationLayout.isAutoDirection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLayout(FlapDockStation flapDockStation, FlapDockStationLayout flapDockStationLayout, Map<Integer, Dockable> map) {
        DockController dockController = flapDockStation.getController();
        try {
            if (dockController != null) {
                dockController.freezeLayout();
            }
            for (int i = flapDockStation.getDockableCount() - 1; i >= 0; --i) {
                flapDockStation.remove(i);
            }
            flapDockStation.setDirection(flapDockStationLayout.getDirection());
            flapDockStation.setAutoDirection(flapDockStationLayout.isAutoDirection());
            if (flapDockStationLayout instanceof RetroFlapDockStationLayout) {
                RetroFlapDockStationLayout retroFlapDockStationLayout = (RetroFlapDockStationLayout)flapDockStationLayout;
                int[] nArray = retroFlapDockStationLayout.getChildren();
                boolean[] blArray = retroFlapDockStationLayout.getHolds();
                int[] nArray2 = retroFlapDockStationLayout.getSizes();
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    Dockable dockable = map.get(nArray[i]);
                    if (dockable == null) continue;
                    flapDockStation.add(dockable);
                    flapDockStation.setHold(dockable, blArray[i]);
                    flapDockStation.setWindowSize(dockable, nArray2[i]);
                }
            } else {
                flapDockStation.setPlaceholders(flapDockStationLayout.getPlaceholders(), map);
            }
        }
        finally {
            if (dockController != null) {
                dockController.meltLayout();
            }
        }
    }

    @Override
    public void estimateLocations(FlapDockStationLayout flapDockStationLayout, final LocationEstimationMap locationEstimationMap) {
        if (flapDockStationLayout instanceof RetroFlapDockStationLayout) {
            RetroFlapDockStationLayout retroFlapDockStationLayout = (RetroFlapDockStationLayout)flapDockStationLayout;
            int[] nArray = retroFlapDockStationLayout.getChildren();
            boolean[] blArray = retroFlapDockStationLayout.getHolds();
            int[] nArray2 = retroFlapDockStationLayout.getSizes();
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                DockLayoutInfo dockLayoutInfo = locationEstimationMap.getChild(nArray[i]);
                if (dockLayoutInfo == null) continue;
                FlapDockProperty flapDockProperty = new FlapDockProperty(i, blArray[i], nArray2[i], dockLayoutInfo.getPlaceholder());
                dockLayoutInfo.setLocation(flapDockProperty);
            }
        } else {
            PlaceholderList.simulatedRead(flapDockStationLayout.getPlaceholders(), new PlaceholderListItemAdapter<PlaceholderListItem>(){

                @Override
                public PlaceholderListItem convert(ConvertedPlaceholderListItem convertedPlaceholderListItem) {
                    int n = convertedPlaceholderListItem.getInt("id");
                    int n2 = convertedPlaceholderListItem.getInt("index");
                    boolean bl = convertedPlaceholderListItem.getBoolean("hold");
                    int n3 = convertedPlaceholderListItem.getInt("size");
                    Path path = null;
                    if (convertedPlaceholderListItem.contains("placeholder")) {
                        path = new Path(convertedPlaceholderListItem.getString("placeholder"));
                    }
                    FlapDockProperty flapDockProperty = new FlapDockProperty(n2, bl, n3, path);
                    locationEstimationMap.getChild(n).setLocation(flapDockProperty);
                    int n4 = locationEstimationMap.getSubChildCount(n);
                    for (int i = 0; i < n4; ++i) {
                        DockLayoutInfo dockLayoutInfo = locationEstimationMap.getSubChild(n, i);
                        dockLayoutInfo.setLocation(new FlapDockProperty(n, bl, n3, dockLayoutInfo.getPlaceholder()));
                    }
                    return null;
                }
            });
        }
    }

    @Override
    public FlapDockStation layout(FlapDockStationLayout flapDockStationLayout, Map<Integer, Dockable> map) {
        FlapDockStation flapDockStation = this.createStation();
        this.setLayout(flapDockStation, flapDockStationLayout, map);
        return flapDockStation;
    }

    @Override
    public FlapDockStation layout(FlapDockStationLayout flapDockStationLayout) {
        FlapDockStation flapDockStation = this.createStation();
        this.setLayout(flapDockStation, flapDockStationLayout);
        return flapDockStation;
    }

    @Override
    public void write(FlapDockStationLayout flapDockStationLayout, DataOutputStream dataOutputStream) throws IOException {
        if (flapDockStationLayout instanceof RetroFlapDockStationLayout) {
            RetroFlapDockStationLayout retroFlapDockStationLayout = (RetroFlapDockStationLayout)flapDockStationLayout;
            Version.write(dataOutputStream, Version.VERSION_1_0_4);
            dataOutputStream.writeBoolean(flapDockStationLayout.isAutoDirection());
            dataOutputStream.writeInt(flapDockStationLayout.getDirection().ordinal());
            int n = retroFlapDockStationLayout.getChildren().length;
            dataOutputStream.writeInt(n);
            for (int i = 0; i < n; ++i) {
                dataOutputStream.writeInt(retroFlapDockStationLayout.getChildren()[i]);
                dataOutputStream.writeBoolean(retroFlapDockStationLayout.getHolds()[i]);
                dataOutputStream.writeInt(retroFlapDockStationLayout.getSizes()[i]);
            }
        } else {
            Version.write(dataOutputStream, Version.VERSION_1_0_8);
            dataOutputStream.writeBoolean(flapDockStationLayout.isAutoDirection());
            dataOutputStream.writeInt(flapDockStationLayout.getDirection().ordinal());
            flapDockStationLayout.getPlaceholders().write(dataOutputStream);
        }
    }

    @Override
    public FlapDockStationLayout read(DataInputStream dataInputStream, PlaceholderStrategy placeholderStrategy) throws IOException {
        Version version = Version.read(dataInputStream);
        version.checkCurrent();
        boolean bl = Version.VERSION_1_0_8.compareTo(version) <= 0;
        boolean bl2 = dataInputStream.readBoolean();
        FlapDockStation.Direction direction = FlapDockStation.Direction.values()[dataInputStream.readInt()];
        if (bl) {
            PlaceholderMap placeholderMap = new PlaceholderMap(dataInputStream, placeholderStrategy);
            placeholderMap.setPlaceholderStrategy(null);
            return new FlapDockStationLayout(bl2, direction, placeholderMap);
        }
        int n = dataInputStream.readInt();
        int[] nArray = new int[n];
        boolean[] blArray = new boolean[n];
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = dataInputStream.readInt();
            blArray[i] = dataInputStream.readBoolean();
            nArray2[i] = dataInputStream.readInt();
        }
        return new RetroFlapDockStationLayout(nArray, blArray, nArray2, bl2, direction);
    }

    @Override
    public void write(FlapDockStationLayout flapDockStationLayout, XElement xElement) {
        if (flapDockStationLayout instanceof RetroFlapDockStationLayout) {
            RetroFlapDockStationLayout retroFlapDockStationLayout = (RetroFlapDockStationLayout)flapDockStationLayout;
            XElement xElement2 = xElement.addElement("window");
            xElement2.addBoolean("auto", flapDockStationLayout.isAutoDirection());
            xElement2.addString("direction", flapDockStationLayout.getDirection().name());
            XElement xElement3 = xElement.addElement("children");
            int n = retroFlapDockStationLayout.getChildren().length;
            for (int i = 0; i < n; ++i) {
                XElement xElement4 = xElement3.addElement("child");
                xElement4.addInt("id", retroFlapDockStationLayout.getChildren()[i]);
                xElement4.addBoolean("hold", retroFlapDockStationLayout.getHolds()[i]);
                xElement4.addInt("size", retroFlapDockStationLayout.getSizes()[i]);
            }
        } else {
            XElement xElement5 = xElement.addElement("window");
            xElement5.addBoolean("auto", flapDockStationLayout.isAutoDirection());
            xElement5.addString("direction", flapDockStationLayout.getDirection().name());
            XElement xElement6 = xElement.addElement("placeholders");
            flapDockStationLayout.getPlaceholders().write(xElement6);
        }
    }

    @Override
    public FlapDockStationLayout read(XElement xElement, PlaceholderStrategy placeholderStrategy) {
        int n;
        int n2;
        XElement xElement2 = xElement.getElement("window");
        XElement xElement3 = xElement.getElement("placeholders");
        if (xElement3 != null) {
            PlaceholderMap placeholderMap = new PlaceholderMap(xElement3, placeholderStrategy);
            placeholderMap.setPlaceholderStrategy(null);
            return new FlapDockStationLayout(xElement2.getBoolean("auto"), FlapDockStation.Direction.valueOf(xElement2.getString("direction")), placeholderMap);
        }
        XElement xElement4 = xElement.getElement("children");
        XElement[] xElementArray = xElement4.getElements("child");
        int[] nArray = new int[xElementArray.length];
        boolean[] blArray = new boolean[xElementArray.length];
        int[] nArray2 = new int[xElementArray.length];
        XAttribute xAttribute = xElement2.getAttribute("size");
        if (xAttribute != null) {
            n2 = xAttribute.getInt();
            for (n = 0; n < nArray2.length; ++n) {
                nArray2[n] = n2;
            }
        } else {
            n = xElementArray.length;
            for (n2 = 0; n2 < n; ++n2) {
                nArray2[n2] = xElementArray[n2].getInt("size");
            }
        }
        n = xElementArray.length;
        for (n2 = 0; n2 < n; ++n2) {
            nArray[n2] = xElementArray[n2].getInt("id");
            blArray[n2] = xElementArray[n2].getBoolean("hold");
        }
        return new RetroFlapDockStationLayout(nArray, blArray, nArray2, xElement2.getBoolean("auto"), FlapDockStation.Direction.valueOf(xElement2.getString("direction")));
    }

    protected FlapDockStation createStation() {
        return new FlapDockStation();
    }
}

