/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic.action.menu;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.MenuDockAction;
import bibliothek.gui.dock.action.view.ViewTarget;
import bibliothek.gui.dock.event.DockActionSourceListener;
import bibliothek.gui.dock.themes.basic.action.menu.AbstractMenuHandler;
import bibliothek.gui.dock.themes.basic.action.menu.MenuViewItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuMenuHandler
extends AbstractMenuHandler<JMenu, MenuDockAction> {
    private DockActionSource source;
    private Menu menu;
    private List<ActionItem> actions = new ArrayList<ActionItem>();
    private Listener sourceListener = new Listener();
    private List<ActionListener> listeners = new ArrayList<ActionListener>();
    private ViewTarget<? extends MenuViewItem<JComponent>> target = ViewTarget.MENU;

    public MenuMenuHandler(MenuDockAction menuDockAction, Dockable dockable) {
        this(menuDockAction, dockable, ViewTarget.MENU);
    }

    public MenuMenuHandler(MenuDockAction menuDockAction, Dockable dockable, ViewTarget<? extends MenuViewItem<JComponent>> viewTarget) {
        super(menuDockAction, dockable, new JMenu());
        if (viewTarget == null) {
            throw new IllegalArgumentException("target must not be null");
        }
        this.target = viewTarget;
        this.setup(menuDockAction.getMenu(dockable), new JMenuWrapper((JMenu)this.item));
    }

    public MenuMenuHandler(DockActionSource dockActionSource, Dockable dockable, JPopupMenu jPopupMenu) {
        super(null, dockable, null);
        this.setup(dockActionSource, new JPopupMenuWrapper(jPopupMenu));
    }

    private void setup(DockActionSource dockActionSource, Menu menu) {
        this.source = dockActionSource;
        this.menu = menu;
    }

    @Override
    public void addActionListener(ActionListener actionListener) {
    }

    @Override
    public void removeActionListener(ActionListener actionListener) {
    }

    public void addChildrenActionListener(ActionListener actionListener) {
        this.listeners.add(actionListener);
    }

    public void removeChildrenActionListener(ActionListener actionListener) {
        this.listeners.remove(actionListener);
    }

    protected void fireActionEvent(ActionEvent actionEvent) {
        for (ActionListener actionListener : this.listeners.toArray(new ActionListener[this.listeners.size()])) {
            actionListener.actionPerformed(actionEvent);
        }
    }

    @Override
    public void bind() {
        super.bind();
        this.source.addDockActionSourceListener(this.sourceListener);
        int n = this.source.getDockActionCount();
        for (int i = 0; i < n; ++i) {
            DockAction dockAction = this.source.getDockAction(i);
            ActionItem actionItem = new ActionItem();
            actionItem.action = dockAction;
            this.actions.add(actionItem);
            MenuViewItem<JComponent> menuViewItem = this.handlerFor(dockAction);
            if (menuViewItem == null) continue;
            actionItem.handler = menuViewItem;
            actionItem.bind();
            actionItem.action.bind(this.dockable);
            menuViewItem.bind();
            this.menu.add((JComponent)menuViewItem.getItem());
        }
    }

    protected MenuViewItem<JComponent> handlerFor(DockAction dockAction) {
        Dockable dockable = this.getDockable();
        MenuViewItem<JComponent> menuViewItem = dockable.getController().getActionViewConverter().createView(dockAction, this.target, dockable);
        return menuViewItem;
    }

    public MenuViewItem<JComponent> getViewFor(DockAction dockAction) {
        for (ActionItem actionItem : this.actions) {
            if (actionItem.action != dockAction) continue;
            return actionItem.handler;
        }
        return null;
    }

    @Override
    public void unbind() {
        super.unbind();
        this.source.removeDockActionSourceListener(this.sourceListener);
        this.menu.removeAll();
        for (ActionItem actionItem : this.actions) {
            actionItem.unbind();
            if (actionItem.handler == null) continue;
            actionItem.handler.unbind();
            actionItem.action.unbind(this.dockable);
        }
        this.actions.clear();
    }

    private static class JPopupMenuWrapper
    implements Menu {
        private JPopupMenu menu;

        public JPopupMenuWrapper(JPopupMenu jPopupMenu) {
            this.menu = jPopupMenu;
        }

        public void add(JComponent jComponent) {
            this.menu.add(jComponent);
        }

        public JMenuItem getItem() {
            return null;
        }

        public void removeAll() {
            this.menu.removeAll();
        }
    }

    private static class JMenuWrapper
    implements Menu {
        private JMenu menu;

        public JMenuWrapper(JMenu jMenu) {
            this.menu = jMenu;
        }

        public void add(JComponent jComponent) {
            this.menu.add(jComponent);
        }

        public JMenuItem getItem() {
            return this.menu;
        }

        public void removeAll() {
            this.menu.removeAll();
        }
    }

    private static interface Menu {
        public void add(JComponent var1);

        public void removeAll();

        public JMenuItem getItem();
    }

    private class ActionItem
    implements ActionListener {
        public DockAction action;
        public MenuViewItem<JComponent> handler;

        private ActionItem() {
        }

        public void bind() {
            if (this.handler != null) {
                this.handler.addActionListener(this);
            }
        }

        public void unbind() {
            if (this.handler != null) {
                this.handler.removeActionListener(this);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MenuMenuHandler.this.fireActionEvent(new ActionEvent(this.action, actionEvent.getID(), actionEvent.getActionCommand(), actionEvent.getWhen(), actionEvent.getModifiers()));
        }
    }

    private class Listener
    implements DockActionSourceListener {
        private Listener() {
        }

        private void reput() {
            MenuMenuHandler.this.menu.removeAll();
            for (ActionItem actionItem : MenuMenuHandler.this.actions) {
                if (actionItem.handler == null) continue;
                MenuMenuHandler.this.menu.add((JComponent)actionItem.handler.getItem());
            }
        }

        public void actionsAdded(DockActionSource dockActionSource, int n, int n2) {
            for (int i = n; i <= n2; ++i) {
                DockAction dockAction = dockActionSource.getDockAction(i);
                ActionItem actionItem = new ActionItem();
                actionItem.action = dockAction;
                MenuMenuHandler.this.actions.add(i, actionItem);
                MenuViewItem<JComponent> menuViewItem = MenuMenuHandler.this.handlerFor(dockAction);
                if (menuViewItem == null) continue;
                dockAction.bind(MenuMenuHandler.this.dockable);
                menuViewItem.bind();
                actionItem.handler = menuViewItem;
                actionItem.bind();
            }
            this.reput();
        }

        public void actionsRemoved(DockActionSource dockActionSource, int n, int n2) {
            for (int i = n2; i >= n; --i) {
                ActionItem actionItem = (ActionItem)MenuMenuHandler.this.actions.remove(i);
                actionItem.unbind();
                if (actionItem.handler == null) continue;
                actionItem.handler.unbind();
                actionItem.action.unbind(MenuMenuHandler.this.dockable);
            }
        }
    }
}

