/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.color;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.themes.ColorBridgeFactory;
import bibliothek.gui.dock.themes.ColorScheme;
import bibliothek.gui.dock.util.Priority;
import bibliothek.gui.dock.util.color.ColorManager;
import bibliothek.gui.dock.util.extension.ExtensionName;
import bibliothek.util.Path;
import java.awt.Color;
import java.util.List;

public class ExtendingColorScheme
implements ColorScheme {
    private ColorScheme scheme;
    private ColorScheme[] extensions;

    public ExtendingColorScheme(ColorScheme colorScheme, DockController dockController) {
        ExtensionName<ColorScheme> extensionName = new ExtensionName<ColorScheme>(ColorScheme.EXTENSION_NAME, ColorScheme.class, "scheme", colorScheme);
        List<ColorScheme> list = dockController.getExtensions().load(extensionName);
        this.scheme = colorScheme;
        this.extensions = list.toArray(new ColorScheme[list.size()]);
        for (ColorScheme colorScheme2 : list) {
            colorScheme2.updateUI();
        }
    }

    public ColorBridgeFactory getBridgeFactory(Path path) {
        for (int i = this.extensions.length - 1; i >= 0; --i) {
            ColorBridgeFactory colorBridgeFactory = this.extensions[i].getBridgeFactory(path);
            if (colorBridgeFactory == null) continue;
            return colorBridgeFactory;
        }
        return this.scheme.getBridgeFactory(path);
    }

    public Color getColor(String string) {
        for (int i = this.extensions.length - 1; i >= 0; --i) {
            Color color = this.extensions[i].getColor(string);
            if (color == null) continue;
            return color;
        }
        return this.scheme.getColor(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transmitAll(Priority priority, ColorManager colorManager) {
        try {
            colorManager.lockUpdate();
            this.scheme.transmitAll(priority, colorManager);
            for (ColorScheme colorScheme : this.extensions) {
                colorScheme.transmitAll(priority, colorManager);
            }
        }
        finally {
            colorManager.unlockUpdate();
        }
    }

    public boolean updateUI() {
        boolean bl = false;
        for (ColorScheme colorScheme : this.extensions) {
            boolean bl2 = colorScheme.updateUI();
            bl |= bl2;
        }
        boolean bl3 = this.scheme.updateUI();
        return bl |= bl3;
    }
}

