/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.SingleCDockable;
import bibliothek.gui.dock.common.event.CControlListener;
import bibliothek.gui.dock.common.intern.CControlAccess;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.gui.dock.station.support.PlaceholderStrategyListener;
import bibliothek.util.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class CPlaceholderStrategy
implements PlaceholderStrategy {
    private CControl control;
    private List<PlaceholderStrategyListener> listeners = new ArrayList<PlaceholderStrategyListener>();
    private CControlListener listener = new CControlListener(){

        public void removed(CControl cControl, CDockable cDockable) {
            if (cDockable instanceof SingleCDockable) {
                String string = ((SingleCDockable)cDockable).getUniqueId();
                Path path = new Path("dock.single." + string);
                if (!CPlaceholderStrategy.this.isValidPlaceholder(path)) {
                    CPlaceholderStrategy.this.fireInvalidated(path);
                }
            }
        }

        public void opened(CControl cControl, CDockable cDockable) {
        }

        public void closed(CControl cControl, CDockable cDockable) {
        }

        public void added(CControl cControl, CDockable cDockable) {
        }
    };

    public CPlaceholderStrategy(CControl cControl) {
        this.control = cControl;
    }

    public void addListener(PlaceholderStrategyListener placeholderStrategyListener) {
        if (placeholderStrategyListener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        if (this.listeners.isEmpty()) {
            this.control.addControlListener(this.listener);
        }
        this.listeners.add(placeholderStrategyListener);
    }

    public void removeListener(PlaceholderStrategyListener placeholderStrategyListener) {
        this.listeners.remove(placeholderStrategyListener);
        if (this.listeners.isEmpty()) {
            this.control.removeControlListener(this.listener);
        }
    }

    protected void fireInvalidated(Path path) {
        HashSet<Path> hashSet = new HashSet<Path>();
        hashSet.add(path);
        hashSet = Collections.unmodifiableSet(hashSet);
        for (PlaceholderStrategyListener placeholderStrategyListener : this.listeners.toArray(new PlaceholderStrategyListener[this.listeners.size()])) {
            placeholderStrategyListener.placeholderInvalidated(hashSet);
        }
    }

    public Path getPlaceholderFor(Dockable dockable) {
        if (!(dockable instanceof CommonDockable)) {
            return null;
        }
        CDockable cDockable = ((CommonDockable)dockable).getDockable();
        CControlAccess cControlAccess = cDockable.getControl();
        if (cControlAccess == null || cControlAccess.getOwner() != this.control) {
            return null;
        }
        if (cDockable instanceof SingleCDockable) {
            String string = ((SingleCDockable)cDockable).getUniqueId();
            return new Path("dock", "single", string);
        }
        return null;
    }

    public boolean isValidPlaceholder(Path path) {
        if (path.getSegmentCount() != 3) {
            return false;
        }
        if (!path.getSegment(0).equals("dock") || !path.getSegment(1).equals("single")) {
            return false;
        }
        String string = path.getSegment(2);
        if (this.control.getSingleDockable(string) != null) {
            return true;
        }
        if (this.control.getSingleBackupFactory(string) != null) {
            return true;
        }
        return this.control.getMissingStrategy().shouldStoreSingle(string);
    }

    public void install(DockStation dockStation) {
    }

    public void uninstall(DockStation dockStation) {
    }
}

