/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.support.mode;

import bibliothek.gui.dock.support.mode.Mode;
import bibliothek.gui.dock.support.mode.ModeSetting;
import bibliothek.gui.dock.support.mode.ModeSettingFactory;
import bibliothek.gui.dock.support.mode.ModeSettingsConverter;
import bibliothek.util.Path;
import bibliothek.util.Version;
import bibliothek.util.xml.XContainer;
import bibliothek.util.xml.XElement;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModeSettings<A, B> {
    private List<DockableEntry> dockables = new ArrayList<DockableEntry>();
    private Map<Path, ModeSetting<A>> modes = new HashMap<Path, ModeSetting<A>>();
    private ModeSettingsConverter<A, B> converter;
    private Map<Path, ModeSettingFactory<A>> factories = new HashMap<Path, ModeSettingFactory<A>>();

    public ModeSettings(ModeSettingsConverter<A, B> modeSettingsConverter) {
        if (modeSettingsConverter == null) {
            throw new IllegalArgumentException("converter must not be null");
        }
        this.converter = modeSettingsConverter;
    }

    public ModeSettingsConverter<A, B> getConverter() {
        return this.converter;
    }

    public void addFactory(ModeSettingFactory<A> modeSettingFactory) {
        this.factories.put(modeSettingFactory.getModeId(), modeSettingFactory);
    }

    public void add(String string, Path path, Map<Path, A> map, Collection<Path> collection) {
        if (string == null) {
            throw new NullPointerException("id");
        }
        if (map == null) {
            throw new NullPointerException("properties");
        }
        if (collection == null) {
            throw new NullPointerException("history");
        }
        DockableEntry dockableEntry = new DockableEntry();
        dockableEntry.id = string;
        dockableEntry.current = path;
        dockableEntry.history = collection.toArray(new Path[collection.size()]);
        dockableEntry.properties = new HashMap();
        for (Map.Entry<Path, A> entry : map.entrySet()) {
            dockableEntry.properties.put(entry.getKey(), this.converter.convertToSetting(entry.getValue()));
        }
        this.dockables.add(dockableEntry);
    }

    public void add(Mode<A> mode) {
        ModeSettingFactory<A> modeSettingFactory = this.factories.get(mode.getUniqueIdentifier());
        if (modeSettingFactory == null) {
            throw new IllegalArgumentException("no factory present for '" + mode.getUniqueIdentifier() + "'");
        }
        ModeSetting<A> modeSetting = modeSettingFactory.create();
        if (modeSetting != null) {
            mode.writeSetting(modeSetting);
            this.modes.put(modeSetting.getModeId(), modeSetting);
        }
    }

    public int size() {
        return this.dockables.size();
    }

    public String getId(int n) {
        return this.dockables.get((int)n).id;
    }

    public Path getCurrent(int n) {
        return this.dockables.get((int)n).current;
    }

    public Path[] getHistory(int n) {
        return this.dockables.get((int)n).history;
    }

    public Map<Path, A> getProperties(int n) {
        HashMap<Path, A> hashMap = new HashMap<Path, A>();
        for (Map.Entry entry : this.dockables.get((int)n).properties.entrySet()) {
            hashMap.put(entry.getKey(), this.converter.convertToWorld(entry.getValue()));
        }
        return hashMap;
    }

    public ModeSetting<A> getSettings(Path path) {
        return this.modes.get(path);
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        Version.write(dataOutputStream, Version.VERSION_1_0_8);
        dataOutputStream.writeInt(this.dockables.size());
        for (DockableEntry object : this.dockables) {
            dataOutputStream.writeUTF(object.id);
            if (object.current == null) {
                dataOutputStream.writeBoolean(false);
            } else {
                dataOutputStream.writeBoolean(true);
                dataOutputStream.writeUTF(object.current.toString());
            }
            dataOutputStream.writeInt(object.history.length);
            for (Path path : object.history) {
                dataOutputStream.writeUTF(path.toString());
            }
            dataOutputStream.writeInt(object.properties.size());
            for (Map.Entry entry : object.properties.entrySet()) {
                dataOutputStream.writeUTF(((Path)entry.getKey()).toString());
                this.converter.writeProperty(entry.getValue(), dataOutputStream);
            }
        }
        dataOutputStream.writeInt(this.modes.size());
        for (ModeSetting modeSetting : this.modes.values()) {
            dataOutputStream.writeUTF(modeSetting.getModeId().toString());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream);
            modeSetting.write(dataOutputStream2, this.converter);
            dataOutputStream.writeInt(byteArrayOutputStream.size());
            byteArrayOutputStream.writeTo(dataOutputStream);
            dataOutputStream2.close();
        }
    }

    protected void rescueSettings(DataInputStream dataInputStream, Version version) throws IOException {
    }

    protected void rescueSettings(XElement xElement) {
    }

    protected Path resuceMode(String string) {
        return null;
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        int n;
        int n2;
        int n3;
        Object object;
        int n4;
        boolean bl;
        Version version = Version.read(dataInputStream);
        version.checkCurrent();
        boolean bl2 = bl = Version.VERSION_1_0_7.compareTo(version) >= 0;
        if (bl) {
            Version.read(dataInputStream);
        }
        this.dockables.clear();
        int n5 = dataInputStream.readInt();
        for (n4 = 0; n4 < n5; ++n4) {
            object = new DockableEntry();
            this.dockables.add((DockableEntry)object);
            ((DockableEntry)object).id = dataInputStream.readUTF();
            if (dataInputStream.readBoolean()) {
                String string = dataInputStream.readUTF();
                ((DockableEntry)object).current = bl ? this.resuceMode(string) : new Path(string);
            }
            ((DockableEntry)object).history = new Path[dataInputStream.readInt()];
            for (n3 = 0; n3 < ((DockableEntry)object).history.length; ++n3) {
                String string = dataInputStream.readUTF();
                ((DockableEntry)object).history[n3] = bl ? this.resuceMode(string) : new Path(string);
            }
            if (bl) {
                n3 = 0;
                for (int i = 0; i < ((DockableEntry)object).history.length; ++i) {
                    if (((DockableEntry)object).history[i] == null) continue;
                    ++n3;
                }
                if (n3 != ((DockableEntry)object).history.length) {
                    Path[] pathArray = ((DockableEntry)object).history;
                    ((DockableEntry)object).history = new Path[n3];
                    n2 = 0;
                    for (n = 0; n < pathArray.length; ++n) {
                        if (pathArray[n] == null) continue;
                        ((DockableEntry)object).history[n2++] = pathArray[n];
                    }
                }
            }
            ((DockableEntry)object).properties = new HashMap();
            int n6 = dataInputStream.readInt();
            for (n3 = 0; n3 < n6; ++n3) {
                String string = dataInputStream.readUTF();
                Path path = bl ? this.resuceMode(string) : new Path(string);
                B b = this.converter.readProperty(dataInputStream);
                if (path == null) continue;
                ((DockableEntry)object).properties.put(path, b);
            }
        }
        this.modes.clear();
        if (bl) {
            this.rescueSettings(dataInputStream, version);
        } else {
            n5 = dataInputStream.readInt();
            for (n4 = 0; n4 < n5; ++n4) {
                int n7;
                object = new Path(dataInputStream.readUTF());
                n3 = dataInputStream.readInt();
                byte[] byArray = new byte[n3];
                n2 = 0;
                for (n = n3; n > 0 && (n7 = dataInputStream.read(byArray, n2, n)) > 0; n -= n7) {
                    n2 += n7;
                }
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                DataInputStream dataInputStream2 = new DataInputStream(byteArrayInputStream);
                ModeSettingFactory<A> modeSettingFactory = this.factories.get(object);
                if (modeSettingFactory == null) continue;
                ModeSetting<A> modeSetting = modeSettingFactory.create();
                modeSetting.read(dataInputStream2, this.converter);
                dataInputStream2.close();
                this.modes.put(modeSetting.getModeId(), modeSetting);
            }
        }
    }

    public void writeXML(XElement xElement) {
        XElement xElement2;
        XElement xElement3 = xElement.addElement("dockables");
        for (DockableEntry object : this.dockables) {
            XElement xElement4 = xElement3.addElement("entry");
            xElement4.addString("id", object.id);
            if (object.current != null) {
                xElement4.addString("current", object.current.toString());
            }
            xElement2 = xElement4.addElement("history");
            for (Path path : object.history) {
                xElement2.addElement("mode").setString(path.toString());
            }
            XElement xElement5 = xElement4.addElement("properties");
            for (Map.Entry entry : object.properties.entrySet()) {
                XElement xElement6 = xElement5.addElement("property");
                xElement6.addString("id", entry.getKey().toString());
                this.converter.writePropertyXML(entry.getValue(), xElement6);
            }
        }
        XElement xElement5 = xElement.addElement("modes");
        for (ModeSetting<A> modeSetting : this.modes.values()) {
            xElement2 = xElement5.addElement("entry");
            xElement2.addString("id", modeSetting.getModeId().toString());
            modeSetting.write(xElement2, this.converter);
        }
    }

    public void readXML(XElement xElement) {
        Object object;
        ModeSettingFactory<A> modeSettingFactory;
        Object object2;
        this.dockables.clear();
        XElement xElement2 = xElement.getElement("dockables");
        if (xElement2 != null) {
            for (XElement xElement3 : xElement2.getElements("entry")) {
                DockableEntry object3 = new DockableEntry();
                this.dockables.add(object3);
                object3.id = xElement3.getString("id");
                object2 = xElement3.getAttribute("current");
                if (object2 != null) {
                    object3.current = new Path(((XContainer)object2).getString());
                }
                if ((modeSettingFactory = xElement3.getElement("history")) == null) {
                    object3.history = new Path[0];
                } else {
                    object = ((XElement)((Object)modeSettingFactory)).getElements("mode");
                    object3.history = new Path[((XElement[])object).length];
                    for (int i = 0; i < ((XElement[])object).length; ++i) {
                        object3.history[i] = new Path(((XElement)object[i]).getString());
                    }
                }
                object = xElement3.getElement("properties");
                object3.properties = new HashMap();
                if (object == null) continue;
                for (XElement xElement4 : ((XElement)object).getElements("property")) {
                    object3.properties.put(new Path(xElement4.getString("id")), this.converter.readPropertyXML(xElement4));
                }
            }
        }
        this.modes.clear();
        XElement xElement5 = xElement.getElement("modes");
        if (xElement5 != null) {
            for (XElement xElement6 : xElement5.getElements("entry")) {
                object2 = new Path(xElement6.getString("id"));
                modeSettingFactory = this.factories.get(object2);
                if (modeSettingFactory == null) continue;
                object = modeSettingFactory.create();
                object.read(xElement6, this.converter);
                this.modes.put(object.getModeId(), (ModeSetting<A>)object);
            }
        } else {
            this.rescueSettings(xElement);
        }
    }

    private class DockableEntry {
        public String id;
        public Path current;
        public Map<Path, B> properties;
        public Path[] history;

        private DockableEntry() {
        }
    }
}

