/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.preference.model;

import bibliothek.extension.gui.dock.preference.AbstractPreferenceModel;
import bibliothek.extension.gui.dock.preference.PreferenceModelListener;
import bibliothek.extension.gui.dock.preference.PreferenceModelText;
import bibliothek.extension.gui.dock.preference.preferences.choice.ButtonContentConditionChoice;
import bibliothek.gui.DockController;
import bibliothek.gui.dock.FlapDockStation;
import bibliothek.gui.dock.station.flap.button.ButtonContent;
import bibliothek.gui.dock.station.flap.button.ButtonContentCondition;
import bibliothek.gui.dock.util.DockProperties;
import bibliothek.gui.dock.util.Priority;
import bibliothek.util.Path;

public class ButtonContentPreferenceModel
extends AbstractPreferenceModel {
    private ButtonContentConditionChoice knobChoice;
    private ButtonContentConditionChoice iconChoice;
    private ButtonContentConditionChoice textChoice;
    private ButtonContentConditionChoice childrenChoice;
    private ButtonContentConditionChoice actionsChoice;
    private ButtonContentConditionChoice filterChoice;
    private String knob;
    private String icon;
    private String text;
    private String children;
    private String actions;
    private String filter;
    private PreferenceModelText knobDescription;
    private PreferenceModelText iconDescription;
    private PreferenceModelText textDescription;
    private PreferenceModelText childrenDescription;
    private PreferenceModelText actionsDescription;
    private PreferenceModelText filterDescription;

    public ButtonContentPreferenceModel(DockController controller) {
        super(controller);
        this.knobChoice = new ButtonContentConditionChoice(controller);
        this.iconChoice = new ButtonContentConditionChoice(controller);
        this.textChoice = new ButtonContentConditionChoice(controller);
        this.childrenChoice = new ButtonContentConditionChoice(controller);
        this.actionsChoice = new ButtonContentConditionChoice(controller);
        this.filterChoice = new ButtonContentConditionChoice(controller);
        this.knobDescription = new PreferenceModelText("preference.buttonContent.knob", this){

            protected void changed(String oldValue, String newValue) {
                ButtonContentPreferenceModel.this.firePreferenceChanged(0, 0);
            }
        };
        this.iconDescription = new PreferenceModelText("preference.buttonContent.icon", this){

            protected void changed(String oldValue, String newValue) {
                ButtonContentPreferenceModel.this.firePreferenceChanged(1, 1);
            }
        };
        this.textDescription = new PreferenceModelText("preference.buttonContent.text", this){

            protected void changed(String oldValue, String newValue) {
                ButtonContentPreferenceModel.this.firePreferenceChanged(2, 2);
            }
        };
        this.childrenDescription = new PreferenceModelText("preference.buttonContent.children", this){

            protected void changed(String oldValue, String newValue) {
                ButtonContentPreferenceModel.this.firePreferenceChanged(3, 3);
            }
        };
        this.actionsDescription = new PreferenceModelText("preference.buttonContent.actions", this){

            protected void changed(String oldValue, String newValue) {
                ButtonContentPreferenceModel.this.firePreferenceChanged(4, 4);
            }
        };
        this.filterDescription = new PreferenceModelText("preference.buttonContent.filter", this){

            protected void changed(String oldValue, String newValue) {
                ButtonContentPreferenceModel.this.firePreferenceChanged(5, 5);
            }
        };
    }

    public void addPreferenceModelListener(PreferenceModelListener listener) {
        if (!this.hasListeners()) {
            this.knobDescription.setController(this.getController());
            this.iconDescription.setController(this.getController());
            this.textDescription.setController(this.getController());
            this.childrenDescription.setController(this.getController());
            this.actionsDescription.setController(this.getController());
            this.filterDescription.setController(this.getController());
        }
        super.addPreferenceModelListener(listener);
    }

    public void removePreferenceModelListener(PreferenceModelListener listener) {
        super.removePreferenceModelListener(listener);
        if (!this.hasListeners()) {
            this.knobDescription.setController(null);
            this.iconDescription.setController(null);
            this.textDescription.setController(null);
            this.childrenDescription.setController(null);
            this.actionsDescription.setController(null);
            this.filterDescription.setController(null);
        }
    }

    public void write() {
        DockProperties properties = this.getController().getProperties();
        properties.setOrRemove(FlapDockStation.BUTTON_CONTENT, this.getContent(), Priority.CLIENT);
        super.write();
    }

    public void read() {
        DockProperties properties = this.getController().getProperties();
        this.setContent(properties.get(FlapDockStation.BUTTON_CONTENT, Priority.CLIENT));
        super.read();
    }

    public ButtonContent getContent() {
        return new ButtonContent((ButtonContentCondition)this.knobChoice.identifierToValue(this.knob), (ButtonContentCondition)this.iconChoice.identifierToValue(this.icon), (ButtonContentCondition)this.textChoice.identifierToValue(this.text), (ButtonContentCondition)this.childrenChoice.identifierToValue(this.children), (ButtonContentCondition)this.actionsChoice.identifierToValue(this.actions), (ButtonContentCondition)this.filterChoice.identifierToValue(this.filter));
    }

    public void setContent(ButtonContent content) {
        this.setValue(0, this.knobChoice.valueToIdentifier(content.getKnob()));
        this.setValue(1, this.iconChoice.valueToIdentifier(content.getIcon()));
        this.setValue(2, this.textChoice.valueToIdentifier(content.getText()));
        this.setValue(3, this.childrenChoice.valueToIdentifier(content.getChildren()));
        this.setValue(4, this.actionsChoice.valueToIdentifier(content.getActions()));
        this.setValue(5, this.filterChoice.valueToIdentifier(content.getActions()));
    }

    public String getLabel(int index) {
        PreferenceModelText text;
        switch (index) {
            case 0: {
                text = this.knobDescription;
                break;
            }
            case 1: {
                text = this.iconDescription;
                break;
            }
            case 2: {
                text = this.textDescription;
                break;
            }
            case 3: {
                text = this.childrenDescription;
                break;
            }
            case 4: {
                text = this.actionsDescription;
                break;
            }
            case 5: {
                text = this.filterDescription;
                break;
            }
            default: {
                throw new IllegalArgumentException("unkonwn property: " + index);
            }
        }
        if (!this.hasListeners()) {
            text.update(this.getController().getTexts());
        }
        return (String)text.value();
    }

    public Path getPath(int index) {
        switch (index) {
            case 0: {
                return new Path("dock.ButtonContent.knob");
            }
            case 1: {
                return new Path("dock.ButtonContent.icon");
            }
            case 2: {
                return new Path("dock.ButtonContent.text");
            }
            case 3: {
                return new Path("dock.ButtonContent.children");
            }
            case 4: {
                return new Path("dock.ButtonContent.actions");
            }
            case 5: {
                return new Path("dock.ButtonContent.filter");
            }
        }
        throw new IllegalArgumentException("unkonwn property: " + index);
    }

    public int getSize() {
        return 6;
    }

    public Path getTypePath(int index) {
        return Path.TYPE_STRING_CHOICE_PATH;
    }

    public Object getValue(int index) {
        switch (index) {
            case 0: {
                return this.knob;
            }
            case 1: {
                return this.icon;
            }
            case 2: {
                return this.text;
            }
            case 3: {
                return this.children;
            }
            case 4: {
                return this.actions;
            }
            case 5: {
                return this.filter;
            }
        }
        throw new IllegalArgumentException("unknown value: " + index);
    }

    public Object getValueInfo(int index) {
        switch (index) {
            case 0: {
                return this.knobChoice;
            }
            case 1: {
                return this.iconChoice;
            }
            case 2: {
                return this.textChoice;
            }
            case 3: {
                return this.childrenChoice;
            }
            case 4: {
                return this.actionsChoice;
            }
            case 5: {
                return this.filterChoice;
            }
        }
        throw new IllegalArgumentException("unknown value: " + index);
    }

    public void setValue(int index, Object value) {
        switch (index) {
            case 0: {
                this.knob = (String)value;
                break;
            }
            case 1: {
                this.icon = (String)value;
                break;
            }
            case 2: {
                this.text = (String)value;
                break;
            }
            case 3: {
                this.children = (String)value;
                break;
            }
            case 4: {
                this.actions = (String)value;
                break;
            }
            case 5: {
                this.filter = (String)value;
            }
        }
        this.firePreferenceChanged(index, index);
    }
}

