/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.common.ExtBasicSpinnerLayout;
import com.jgoodies.looks.plastic.PlasticArrowButton;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSpinnerUI;

public class PlasticSpinnerUI
extends BasicSpinnerUI {
    public static ComponentUI createUI(JComponent b) {
        return new PlasticSpinnerUI();
    }

    protected Component createPreviousButton() {
        Component c = this.createArrowButton(5);
        this.installPreviousButtonListenersFromSuper(c);
        return c;
    }

    protected Component createNextButton() {
        Component c = this.createArrowButton(1);
        this.installNextButtonListenersFromSuper(c);
        return c;
    }

    protected Component createArrowButton(int direction) {
        return new SpinnerArrowButton(direction);
    }

    protected void installPreviousButtonListenersFromSuper(Component c) {
        AbstractButton sc = (AbstractButton)super.createPreviousButton();
        ActionListener[] als = sc.getActionListeners();
        MouseListener[] mls = sc.getMouseListeners();
        if (c instanceof AbstractButton) {
            ((AbstractButton)c).addActionListener(als[0]);
        }
        c.addMouseListener(mls[0]);
    }

    protected void installNextButtonListenersFromSuper(Component c) {
        AbstractButton sc = (AbstractButton)super.createNextButton();
        ActionListener[] als = sc.getActionListeners();
        MouseListener[] mls = sc.getMouseListeners();
        if (c instanceof AbstractButton) {
            ((AbstractButton)c).addActionListener(als[0]);
        }
        c.addMouseListener(mls[0]);
    }

    protected LayoutManager createLayout() {
        return new ExtBasicSpinnerLayout();
    }

    protected JComponent createEditor() {
        JComponent editor = this.spinner.getEditor();
        this.configureEditorBorder(editor);
        return editor;
    }

    protected void replaceEditor(JComponent oldEditor, JComponent newEditor) {
        this.spinner.remove(oldEditor);
        this.configureEditorBorder(newEditor);
        this.spinner.add((Component)newEditor, "Editor");
    }

    private void configureEditorBorder(JComponent editor) {
        if (editor instanceof JSpinner.DefaultEditor) {
            JSpinner.DefaultEditor defaultEditor = (JSpinner.DefaultEditor)editor;
            JFormattedTextField editorField = defaultEditor.getTextField();
            Insets insets = UIManager.getInsets("Spinner.defaultEditorInsets");
            editorField.setBorder(new EmptyBorder(insets));
        } else if (editor instanceof JPanel && editor.getBorder() == null && editor.getComponentCount() > 0) {
            JComponent editorField = (JComponent)editor.getComponent(0);
            Insets insets = UIManager.getInsets("Spinner.defaultEditorInsets");
            editorField.setBorder(new EmptyBorder(insets));
        }
    }

    private static final class SpinnerArrowButton
    extends PlasticArrowButton {
        private SpinnerArrowButton(int direction) {
            super(direction, UIManager.getInt("ScrollBar.width"), true);
        }

        protected int calculateArrowHeight(int height, int width) {
            int arrowHeight = Math.min((height - 4) / 3, (width - 4) / 3);
            return Math.max(arrowHeight, 3);
        }

        protected int calculateArrowOffset() {
            return 1;
        }

        protected boolean isPaintingNorthBottom() {
            return true;
        }
    }
}

