/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.screen;

import bibliothek.gui.dock.ScreenDockStation;
import bibliothek.gui.dock.station.screen.AbstractScreenDockWindow;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JDesktopPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class InternalDockDialog
extends AbstractScreenDockWindow {
    private JDesktopPane desktop;
    private JPanel dialog;

    public InternalDockDialog(ScreenDockStation station, JDesktopPane desktop) {
        super(station);
        this.desktop = desktop;
        this.init();
    }

    private void init() {
        this.dialog = new JPanel();
        this.dialog.setVisible(false);
        this.desktop.add(this.dialog);
        this.desktop.setLayer(this.dialog, JDesktopPane.MODAL_LAYER);
        this.init(this.dialog, this.dialog, true);
    }

    protected void convertPointToScreen(Point point, Component component) {
        Point result = SwingUtilities.convertPoint(component, point, this.desktop);
        point.x = result.x;
        point.y = result.y;
    }

    public void setWindowBounds(Rectangle bounds, boolean screenCoordinates) {
        if (screenCoordinates) {
            Point location = bounds.getLocation();
            SwingUtilities.convertPointFromScreen(location, this.desktop);
            bounds = new Rectangle(location, bounds.getSize());
        }
        super.setWindowBounds(bounds, false);
    }

    public void destroy() {
        this.dialog.setVisible(false);
        this.desktop.remove(this.dialog);
    }

    public void toFront() {
        this.desktop.moveToFront(this.dialog);
    }
}

