% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spflow-simulations.R
\name{expand_flow_neighborhood}
\alias{expand_flow_neighborhood}
\title{Derive the flow neighborhood matrices}
\usage{
expand_flow_neighborhood(
  OW,
  DW,
  n_o = OW \%|!|\% nrow(OW),
  n_d = DW \%|!|\% nrow(DW),
  model = "model_9"
)
}
\arguments{
\item{OW}{Origin neighborhood matrix}

\item{DW}{Destination neighborhood matrix}

\item{n_o}{A numeric indicating the number of origins}

\item{n_d}{A numeric indicating the number of destinations}

\item{model}{A character indicating the model identifier}
}
\description{
Use the neighborhood matrices of origins and destinations to derive the
three neighborhood matrices of the origin-destination flows.
This function is used for simulations or for comparisons with the vectorized
formulations of the model.
}
\seealso{
Other spflow simulation functions: 
\code{\link{spatial_filter}()},
\code{\link{spflow_sim}()}
}
\concept{spflow simulation functions}
\keyword{internal}
