% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sobolev.R
\name{sph_stat_Sobolev}
\alias{sph_stat_Sobolev}
\alias{cir_stat_Sobolev}
\title{Finite Sobolev statistics for testing (hyper)spherical uniformity}
\usage{
sph_stat_Sobolev(X, Psi_in_X = FALSE, p = 0, vk2 = c(0, 0, 1))

cir_stat_Sobolev(Theta, Psi_in_Theta = FALSE, vk2 = c(0, 0, 1))
}
\arguments{
\item{X}{an \bold{array} of size \code{c(n, p, M)} containing the Cartesian
coordinates of \code{M} samples of size \code{n} of directions on
\eqn{S^{p-1}}. Must not contain \code{NA}'s.}

\item{Psi_in_X}{does \code{X} contain the shortest angles matrix
\eqn{\boldsymbol\Psi}{\Psi} that is obtained with \code{\link{Psi_mat}(X)}?
If \code{FALSE} (default), \eqn{\boldsymbol\Psi}{\Psi} is computed
internally.}

\item{p}{integer giving the dimension of the ambient space \eqn{R^p} that
contains \eqn{S^{p-1}}.}

\item{vk2}{weights for the finite Sobolev test. A non-negative vector or
matrix. Defaults to \code{c(0, 0, 1)}.}

\item{Theta}{a \bold{matrix} of size \code{c(n, M)} with \code{M} samples
of size \code{n} of circular data on \eqn{[0, 2\pi)}. Must not contain
\code{NA}'s.}

\item{Psi_in_Theta}{does \code{Theta} contain the shortest angles matrix
\eqn{\boldsymbol\Psi}{\Psi} that is obtained with
\cr\code{\link{Psi_mat}(array(Theta, dim = c(n, 1, M)))}? If \code{FALSE}
(default), \eqn{\boldsymbol\Psi}{\Psi} is computed internally.}
}
\value{
A matrix of size \code{c(M, ncol(vk2))} containing the statistics for
each of the \code{M} samples.
}
\description{
Computes the finite Sobolev statistic \deqn{
S_{n, p}(\{b_{k, p}\}_{k=1}^K) = \sum_{i, j = 1}^n
\sum_{k = 1}^K b_{k, p}C_k^(p / 2 - 1)(\cos^{-1}({\bf X}_i'{\bf X}_j)),}
for a sequence  \eqn{\{b_{k, p}\}_{k = 1}^K} of non-negative weights. For
\eqn{p = 2}, the Gegenbauer polynomials are replaced by Chebyshev ones.
}
