% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tiporder.R
\name{tiporder}
\alias{tiporder}
\title{Orders tip labels by their position on the tree.}
\usage{
tiporder(phy, labels = TRUE)
}
\arguments{
\item{phy}{A tree of class `phylo'.}

\item{labels}{Logical. Should labels be printed? If FALSE, the indices are
given. Default of TRUE.}
}
\value{
A character or numeric vector giving the names of the tip in the
order of their position on the tree. The order is that from top to bottom
when the tree is plotted with \code{direction = "rightwards"}.
}
\description{
Provides an ordered vector of tip labels, corresponding to their position on
the tree.
}
\examples{

data(anoteropsis)
anoTree <- ape::nj(ape::dist.dna(anoteropsis))
tiporder(anoTree)
tiporder(anoTree, labels = FALSE)


data(woodmouse)
woodTree <- ape::nj(ape::dist.dna(woodmouse))
tiporder(woodTree)
tiporder(ape::ladderize(woodTree))

}
\author{
Samuel Brown <s_d_j_brown@hotmail.com>
}
\keyword{Utilities}
