% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mmiWMRR.R
\name{mmiWMRR}
\alias{mmiWMRR}
\title{Multi-model inference for wavelet multiresolution regression}
\usage{
mmiWMRR(object, data, scale, detail = TRUE, trace = FALSE)
}
\arguments{
\item{object}{A model of class \code{WRM}.}

\item{data}{Data frame.}

\item{scale}{0 or higher integers possible (limit depends on sample size).
\code{scale}=1 is equivalent to \code{WRM} with \code{level}=1.}

\item{detail}{Remove smooth wavelets? If \code{TRUE}, only detail
components are analyzed. If set to \code{FALSE}, smooth and detail
components are analyzed. Default is \code{TRUE}.}

\item{trace}{Logical value indicating whether to print results to console.}
}
\value{
\code{mmiWMRR} returns a list containing the following elements
\describe{
  \item{\code{result}}{A matrix containing slopes, degrees of freedom, likelihood,
         AIC, delta, and weight values for the set of candidate models.
         The models are ranked by AIC.}
  \item{\code{level}}{An integer corresponding to scale}

}
}
\description{
mmiWMRR is a multimodel inference approach evaluating the relative
importance of predictors used in \code{\link{scaleWMRR}}.
}
\details{
It performs automatically
generated model selection and creates a model
selection table according to the approach of multi-model inference
(Burnham & Anderson, 2002). The analysis is carried out for scale-specific
regressions (i.e. where \code{\link{scaleWMRR}} can be used). AIC is
used to obtain model
selection weights and to rank the models.
Futhermore, this function requires that \strong{all predictor variables
be continuous}.
}
\examples{

data(carlinadata)
coords <- carlinadata[ ,4:5]
\dontrun{


wrm<- WRM(carlina.horrida ~ aridity + land.use, family = "poisson",
          data = carlinadata, coord = coords, level = 1,
          wavelet = "d4")

mmi<- mmiWMRR(wrm, data = carlinadata, scale = 3,
              detail = TRUE, trace = FALSE)

}
}
\references{
Burnham, K.P. & Anderson, D.R. (2002) Model selection and
multimodel inference. Springer, New York.

Carl G, Doktor D, Schweiger O, Kuehn I (2016)
Assessing relative variable importance across different spatial
scales: a two-dimensional wavelet analysis.
Journal of Biogeography 43: 2502-2512.
}
\seealso{
\code{\link{aic.calc}}, \code{\link{rvi.plot}},
\pkg{MuMIn}, \code{\link{WRM}}
}
\author{
Gudrun Carl
}
