% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_render.r
\name{render_plotly}
\alias{render_plotly}
\title{Render the slides as a \emph{plotly} animation.}
\usage{
render_plotly(fps = 3L, tooltip = "none", html_filename = NULL, ...)
}
\arguments{
\item{fps}{Frames/slides shown per second. Defaults to 3.}

\item{tooltip}{Character vector of aesthetic mappings to show in the \code{plotly}
hover-over tooltip. Defaults to "none". "all" shows all the
aesthetic mappings. The order of variables controls the order they appear.
For example, tooltip = c("id", "frame", "x", "y", "category", "color").}

\item{html_filename}{Optional, saves the plotly object as an HTML widget to this string
(without folderpath). Defaults to NULL (not saved). For more control call
\code{htmlwidgets::saveWidget()} on a return object of \code{render_plotly()}.}

\item{...}{Optionally passes arguments to the projection points inside the
aesthetics; \code{geom_point(aes(...))}.}
}
\description{
Takes the result of \code{array2df()} and renders them into a
\emph{plotly} animation.
}
