% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_util.r
\name{map_absolute}
\alias{map_absolute}
\title{Manually offset and scale the first 2 columns of a matrix or data.frame.}
\usage{
map_absolute(x, offset = c(0, 0), scale = c(1, 1))
}
\arguments{
\item{x}{Numeric data object with 2 columns to scale and offset.
Defaults to NULL, passing arguments to scale_axes for use internally.}

\item{offset}{2 Numeric values to offset/pan the first 2 dimensions of \code{x}.}

\item{scale}{2 Numeric values to scale/zoom to the first 2 dimensions of \code{x}.}
}
\value{
Scaled and offset \code{x}.
}
\description{
A manual variant of \code{map_relative()}. Can be used as the \code{axes} argument
to manually set the size and locations of the axes.
}
\examples{
bas <- tourr::basis_random(4, 2)

map_absolute(bas, offset = c(-2, 0), scale = c(2/3, 2/3))
}
\seealso{
\code{\link{scale_axes}} for preset choices.

Other linear mapping functions: 
\code{\link{map_relative}()}
}
\concept{linear mapping functions}
