% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_ggproto_visualize.r
\name{proto_density2d}
\alias{proto_density2d}
\title{Tour proto for data, 1D density, with rug marks}
\usage{
proto_density2d(
  aes_args = list(),
  identity_args = list(bins = 4),
  row_index = NULL
)
}
\arguments{
\item{aes_args}{A list of arguments to call inside of aes().
aesthetic mapping of the primary geom. For example,
\code{geom_point(aes(color = my_fct, shape = my_fct))} becomes
\code{aes_args = list(color = my_fct, shape = my_fct)}.}

\item{identity_args}{A list of static, identity arguments passed into
the primary geom. For instance,
\code{geom_point(size = 2, alpha = .7)} becomes
\code{identity_args = list(size = 2, alpha = .7)}.
Also passes more foundational arguments such as stat and position, though
these have been tested less.}

\item{row_index}{A numeric or logical index of rows to subset to.
Defaults to NULL, all observations.}
}
\description{
Adds \code{geom_density_2d()} of the projected data.
}
\examples{
library(spinifex)
dat     <- scale_sd(penguins_na.rm[, 1:4])
clas    <- penguins_na.rm$species
gt_path <- save_history(dat, grand_tour(), max = 3)

## geom_density_2d args can be passed in identity_args (bins, binwidth, breaks) 
ggt <- ggtour(gt_path, dat, angle = .3) +
  proto_density2d(aes_args = list(color = clas, fill = clas),
                  identity_args = list(binwidth = .3)) +
  proto_point(aes_args = list(color = clas, shape = clas),
              identity_args = list(alpha = .2)) +
  proto_basis()
\donttest{
animate_plotly(ggt)
}
}
\seealso{
Other ggtour proto functions: 
\code{\link{append_fixed_y}()},
\code{\link{facet_wrap_tour}()},
\code{\link{ggtour}()},
\code{\link{proto_basis}()},
\code{\link{proto_default}()},
\code{\link{proto_density}()},
\code{\link{proto_hex}()},
\code{\link{proto_highlight}()},
\code{\link{proto_hline0}()},
\code{\link{proto_origin}()},
\code{\link{proto_point}()},
\code{\link{proto_text}()}
}
\concept{ggtour proto functions}
