% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spiro_summary.R
\name{spiro_summary}
\alias{spiro_summary}
\title{Stepwise summarize data from cardiopulmonary exercise testing}
\usage{
spiro_summary(data, interval = 120, quiet = FALSE, exclude = FALSE)
}
\arguments{
\item{data}{A \code{data.frame} of the class \code{spiro_*}, as it is
generated by \code{\link{spiro}}.}

\item{interval}{An integer giving the length of the computational interval in
seconds.}

\item{quiet}{A logical value, whether or not messages should be displayed,
for example when intervals were shortened for specific steps.}

\item{exclude}{A logical value, whether the last step should be excluded from
the summary if it was not completely performed.}
}
\value{
A \code{data.frame} with the mean parameters for each step of the
exercise protocol.
}
\description{
\code{spiro_summary()} returns a \code{data.frame} summarizing the main
parameters for each step of a spiroergometric test.
}
\details{
This function generates mean values of gas exchange and cardiac parameters
for all steps of a spiroergometric test. For calculation the given
\code{interval} before the end of each step is used.

If the interval exceeds the duration of any step, a message will be
displayed. If the interval exceeds the duration of all steps, it will be
reset to the duration of the longest step. You can silence all messages by
setting \code{quiet = TRUE}.

When setting \code{exclude = TRUE} the function will check whether the last
load step was terminated early. If this was the case, the step will not be
displayed in the summary.
}
\examples{
# Import and process example data
gxt_data <- spiro(file = spiro_example("zan_gxt"))

spiro_summary(gxt_data)
}
