% Generated by roxygen2 (4.0.2): do not edit by hand
\name{concat.split.compact}
\alias{concat.split.compact}
\title{Split Concatenated Cells into a Condensed Format}
\usage{
concat.split.compact(data, split.col, sep = ",", drop = FALSE,
  fixed = TRUE, ...)
}
\arguments{
\item{data}{The source \code{data.frame} or \code{data.table}}

\item{split.col}{The variable that needs to be split (either name or index
position).}

\item{sep}{The character separating each value.}

\item{drop}{Logical. Should the original variable be dropped? Defaults to
\code{FALSE}.}

\item{fixed}{Logical. Should the split character be treated as a fixed
pattern (\code{TRUE}) or a regular expression (\code{FALSE})? Defaults to
\code{TRUE}.}

\item{\dots}{optional arguments to pass to \code{cSplit}.}
}
\value{
A \code{data.table}.
}
\description{
The default splitting method for \code{\link{concat.split}}. Formerly based
on \code{\link{read.concat}} but presently a simple wrapper for
\code{\link{cSplit}}..
}
\note{
This function no longer does anything different from
\code{\link{cSplit}}. It is recommended that you transition your code to the
\code{cSplit} function instead.
}
\examples{
temp <- head(concat.test)
concat.split.compact(temp, "Likes")
concat.split.compact(temp, 4, ";")

## Extra arguments to cSplit
concat.split.compact(temp, "Siblings", drop = TRUE, stripWhite = TRUE)

\dontshow{rm(temp)}
}
\author{
Ananda Mahto
}
\seealso{
\code{\link{read.concat}}, \code{\link{cSplit}}
}

