% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spm12_realign_est.R
\name{spm12_realign_est}
\alias{spm12_realign_est}
\title{SPM12 Realign (Estimate)}
\usage{
spm12_realign_est(filename, fwhm = 5, register_to = c("first", "mean"),
  add_spm_dir = TRUE, spmdir = spm_dir(), clean = TRUE, verbose = TRUE,
  outdir = NULL, ...)
}
\arguments{
\item{filename}{Files to be realigned}

\item{fwhm}{Full-Width Half Max to smooth}

\item{register_to}{Should the files be registered to the first or the mean}

\item{add_spm_dir}{Add SPM12 directory from this package}

\item{spmdir}{SPM dir to add, will use package default directory}

\item{clean}{Remove scripts from temporary directory after running}

\item{verbose}{Print diagnostic messages}

\item{outdir}{Directory to copy results.  If full filename given, then results will
be in \code{dirname(filename)}}

\item{...}{Arguments passed to \code{\link{run_spm12_script}}}
}
\value{
Character list of filenames from output
}
\description{
Performs SPM12 Realignment estimation on an Image
}
