% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spm12_normalize_est.R
\name{spm12_normalize_est}
\alias{spm12_normalize_est}
\title{SPM12 Normalize (Estimate)}
\usage{
spm12_normalize_est(
  filename,
  biasreg = 0.001,
  biasfwhm = 60,
  regularization = c(0, 0.001, 0.5, 0.05, 0.2),
  affine = c("mni", "eastern", "subj", "none", ""),
  smoothness = 0,
  sampling_distance = 3,
  add_spm_dir = TRUE,
  spmdir = spm_dir(verbose = verbose, install_dir = install_dir),
  clean = TRUE,
  verbose = TRUE,
  install_dir = NULL,
  ...
)
}
\arguments{
\item{filename}{File to be normalized to the template}

\item{biasreg}{Amount of bias regularization}

\item{biasfwhm}{FWHM  of  Gaussian  smoothness  of  bias.}

\item{regularization}{parameters for warping regularization}

\item{affine}{Space to register the image to, using an affine registration}

\item{smoothness}{FWHM of smoothing done}

\item{sampling_distance}{amount of smoothing of the warping field. 
This is used to derive a fudge factor to account for 
correlations between neighbouring voxels.  Smoother data have more}

\item{add_spm_dir}{Add SPM12 directory from this package}

\item{spmdir}{SPM dir to add, will use package default directory}

\item{clean}{Remove scripts from temporary directory after running}

\item{verbose}{Print diagnostic messages}

\item{install_dir}{directory to download SPM12}

\item{...}{Arguments passed to \code{\link{run_spm12_script}}}
}
\value{
Result from run_matlab_script
}
\description{
Estimate SPM12 (Spatial) Normalization from image
}
