% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ccr.R
\name{ccr}
\alias{ccr}
\title{Correct classification rate for predictive models based on cross
-validation}
\usage{
ccr(obs, pred)
}
\arguments{
\item{obs}{a vector of observation values of validation samples.}

\item{pred}{a vector of prediction values of predictive models for validation samples.}
}
\value{
A list with the following component:
ccr (correct classification rate) for categorical data.
}
\description{
This function is to calculates correct classification
rate (ccr) for categorical data with the observed (obs) data specified
as factor. It based on the differences between the predicted values for
and the observed values of validation samples for cross-validation. For 0
and 1 data, the observed values need to be specified as factor in order
to use this accuracy measure. It is modified from the function 'pred.acc'
 in 'spm' package.
}
\examples{
set.seed(1234)
x <- as.factor(sample(letters[1:2], 30, TRUE))
y <- sample(x, 30)
ccr(x, y)

}
\references{
Jin Li (2019). spm: Spatial Predictive Modeling. R package
version 1.2.0. https://CRAN.R-project.org/package=spm.
}
\author{
Jin Li
}
