% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R, R/spooky.R
\docType{package}
\name{spooky}
\alias{spooky}
\alias{spooky-package}
\title{spooky}
\usage{
spooky(
  df,
  seq_len = NULL,
  lno = NULL,
  n_samp = 30,
  n_windows = 3,
  ci = 0.8,
  smoother = FALSE,
  dates = NULL,
  error_scale = "naive",
  error_benchmark = "naive",
  bounds = NULL,
  seed = 42
)
}
\arguments{
\item{df}{A data frame with time features on columns}

\item{seq_len}{Positive integer. Time-step number of the forecasting sequence. Default: NULL (automatic selection between 1 and the square root of full length).}

\item{lno}{Positive integer. Number of data points to leave out for resampling (using jack-knife approach). Default: NULL (automatic selection between 1 and the square root of full length).}

\item{n_samp}{Positive integer. Number of samples for random search. Default: 30.}

\item{n_windows}{Positive integer. Number of validation windows to test prediction error. Default: 10.}

\item{ci}{Confidence interval for prediction. Default: 0.8}

\item{smoother}{Logical. Flag to TRUE for loess smoothing. Default: FALSE.}

\item{dates}{Date. Vector with dates for time features.}

\item{error_scale}{String. Scale for the scaled error metrics. Two options: "naive" (average of naive one-step absolute error for the historical series) or "deviation" (standard error of the historical series). Default: "naive".}

\item{error_benchmark}{String. Benchmark for the relative error metrics. Two options: "naive" (sequential extension of last value) or "average" (mean value of true sequence). Default: "naive".}

\item{bounds}{list of numeric vector, with minimum and maximum bounds for each numeric features. Default: NULL}

\item{seed}{Positive integer. Random seed. Default: 42.}
}
\value{
This function returns a list including:
\itemize{
\item exploration: list of all not-null models, complete with predictions, test metrics, prediction stats and plot
\item history: a table with the sampled models, hyper-parameters, validation errors
\item best_model: results for the best selected model according to the weighted average rank, including:
\itemize{
\item testing_errors: testing errors for each time feature for the best selected model (for continuous variables: me, mae, mse, rmsse, mpe, mape, rmae, rrmse, rame, mase, smse, sce, gmrae; for factor variables: czekanowski, tanimoto, cosine, hassebrook, jaccard, dice, canberra, gower, lorentzian, clark)
\item preds: for continuous variables, min, max, q25, q50, q75, quantiles at selected ci, mean, sd, mode, skewness, kurtosis, IQR to range, risk ratio, upside probability and divergence for each point fo predicted sequences; for factor variables, min, max, q25, q50, q75, quantiles at selected ci, proportions, difformity (deviation of proportions normalized over the maximum possible deviation), entropy, upgrade probability and divergence for each point fo predicted sequences
\item plots: standard plot with confidence interval for each time feature
}
\item time_log
}
}
\description{
Automatic jack-knife of spectral analysis for time feature extrapolation
}
\examples{
spooky(time_features, seq_len = c(10, 30), lno = c(1, 30), n_samp = 1)


}
\seealso{
Useful links:
\itemize{
  \item \url{https://rpubs.com/giancarlo_vercellino/spooky}
}

}
\author{
Giancarlo Vercellino \email{giancarlo.vercellino@gmail.com}
}
