% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotmath.R
\name{as_plotmath.spork}
\alias{as_plotmath.spork}
\title{Convert Spork to Plotmath}
\usage{
\method{as_plotmath}{spork}(x, ...)
}
\arguments{
\item{x}{spork}

\item{...}{passed to \code{\link{as_plotmath.spar}}}
}
\value{
plotmath
}
\description{
Converts spork to plotmath. See \code{\link[grDevices]{plotmath}}.
Vectorized version of \code{\link{as_plotmath.spar}}.
}
\examples{
library(magrittr)
'V_c./F' \%>\% as_spork \%>\% as_plotmath
'AUC_ss' \%>\% as_spork \%>\% as_plotmath
'C_max_ss' \%>\% as_spork \%>\% as_plotmath
'var^eta_j' \%>\% as_spork \%>\% as_plotmath
'one joule (Omega) ~ 1 kg*m^2./s^2' \%>\% as_spork \%>\% as_plotmath
}
\seealso{
Other plotmath: 
\code{\link{[.plotmath}()},
\code{\link{[[.plotmath}()},
\code{\link{as.expression.plotmath}()},
\code{\link{as.png.plotmath}()},
\code{\link{as_plotmath.spar}()},
\code{\link{as_plotmath}()},
\code{\link{concatenate.plotmath}()},
\code{\link{ggplot.plotmath}()},
\code{\link{goodToken}()},
\code{\link{plotmathToken}()}

Other spork: 
\code{\link{[.spork}()},
\code{\link{[[.spork}()},
\code{\link{as.list.spork}()},
\code{\link{as.png.spork}()},
\code{\link{as_html.spork}()},
\code{\link{as_latex.spork}()},
\code{\link{as_previews.spork}()},
\code{\link{as_spar.spork}()},
\code{\link{as_spork.character}()},
\code{\link{as_spork.factor}()},
\code{\link{as_spork.spork}()},
\code{\link{as_spork}()},
\code{\link{ggplot.spork}()}

Other interface: 
\code{\link{as.expression.plotmath}()},
\code{\link{as_html.spar}()},
\code{\link{as_html.spork}()},
\code{\link{as_latex.spar}()},
\code{\link{as_latex.spork}()},
\code{\link{as_plotmath.spar}()},
\code{\link{as_previews.spork}()},
\code{\link{as_spork.character}()},
\code{\link{htmlToken}()},
\code{\link{latexToken}()},
\code{\link{plotmathToken}()}
}
\concept{interface}
\concept{plotmath}
\concept{spork}
