% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rating_run.R
\name{rating_run}
\alias{rating_run}
\title{Apply rating algorithm}
\usage{
rating_run(
  method,
  data,
  formula,
  r = numeric(0),
  rd = numeric(0),
  sigma = numeric(0),
  init_r = numeric(0),
  init_rd = numeric(0),
  init_sigma = numeric(0),
  lambda = numeric(0),
  share = numeric(0),
  weight = numeric(0),
  kappa = numeric(0),
  tau = numeric(0)
)
}
\arguments{
\item{method}{one of \code{c("glicko", "glicko2", "bbt", "dbl")}}

\item{data}{data.frame which contains columns specified in formula, and
optional columns defined by \code{lambda}, \code{weight}.}

\item{formula}{formula which specifies the model. RHS Allows only player
rating parameter and it should be specified in following manner:\cr

\code{rank | id ~ player(name)}.
\itemize{
\item \code{rank} player position in event.
\item \code{id} event identifier in which pairwise comparison is assessed.
\item \code{player(name)} name of the contestant. In this case \code{player(name)}
helps algorithm point name of the column where player names are stored.
}

Users can also specify formula in in different way:\cr

\code{rank | id ~ player(name|team)}. Which means that players are playing in teams,
and results are observed for teams not for players. For more see vignette.}

\item{r}{named vector of initial players ratings estimates. If not specified
then \code{r} will be created automatically for parameters specified in \code{formula}
with initial value \code{init_r}.}

\item{rd}{rd named vector of initial rating deviation estimates. If not specified
then \code{rd} will be created automatically for parameters specified in \code{formula}
with initial value \code{init_rd}.}

\item{sigma}{(only for glicko2) named vector of initial players ratings
estimates. If not specified then \code{sigma} will be created automatically for
parameters specified in \code{formula} with initial value \code{init_sigma}.}

\item{init_r}{initial values for \code{r} if not provided.
Default (\code{glicko = 1500}, \code{glicko2 = 1500}, \code{bbt = 25},
\code{dbl = 0})}

\item{init_rd}{initial values for \code{rd} if not provided.
Default (\code{glicko = 350}, \code{glicko2 = 350}, \code{bbt = 25/3}, \code{dbl = 1})}

\item{init_sigma}{initial values for \code{sigma} if not provided.
Default = 0.5}

\item{lambda}{name of the column in \code{data} containing lambda values or one
constant value (eg. \code{lambda = colname} or \code{lambda = 0.5}).
Lambda impact prior variance, and uncertainty of the matchup result. The
higher lambda, the higher prior variance and more uncertain result of the
matchup. Higher lambda flattens chances of winning.}

\item{share}{name of the column in \code{data} containing player share in team
efforts. It's used to first calculate combined rating of the team and
then redistribute ratings update back to players level. Warning - it should
be used only if formula is specified with players nested within teams (\code{player(player|team)}).}

\item{weight}{name of the column in \code{data} containing weights values or
one constant (eg. \code{weight = colname} or \code{weight = 0.5}).
Weights increasing (weight > 1) or decreasing (weight < 1) update change.
Higher weight increasing impact of event result on rating estimate.}

\item{kappa}{controls \code{rd} shrinkage not to be greater than \code{rd*(1 - kappa)}.
\code{kappa=1} means that  \code{rd} will not be decreased.}

\item{tau}{The system constant. Which constrains the change in volatility over
time. Reasonable choices are between 0.3 and 1.2 (\code{default = 0.5}), though
the system should be tested to decide which value results in greatest
predictive accuracy. Smaller values of \code{tau} prevent the volatility measures
from changing by large amounts, which in turn prevent enormous changes in
ratings based on very improbable results. If the application of Glicko-2 is
expected to involve extremely improbable collections of game outcomes, then
\code{tau} should be set to a small value, even as small as, say, \code{tau= 0}.}
}
\description{
Apply rating algorithm
}
\keyword{internal}
