% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/features-lacrosse.R
\name{lacrosse_goal_circle}
\alias{lacrosse_goal_circle}
\title{The goal circle is a circular feature on the field that houses the goal line
(see \code{\link[=lacrosse_goal_line]{lacrosse_goal_line()}}) and the goal. Notably, for fields with a
surrounding arc and/or fan around the goal area, this feature \emph{only}
circumscribes the goal. Those features will be handled separately. This
feature may either be the full circle (e.g. all 360 degrees), or a partial
circle that may be greater than a half-circle}
\usage{
lacrosse_goal_circle(
  goal_circle_radius = 0,
  line_thickness = 0,
  goal_circle_full_360 = TRUE,
  goal_depth = 0,
  goal_depth_to_circle = 0
)
}
\arguments{
\item{goal_circle_radius}{The outer radius of the goal circle}

\item{line_thickness}{The thickness of the goal circle}

\item{goal_circle_full_360}{A boolean indicating whether the goal circle
should be a 360 degree circle}

\item{goal_depth}{The depth of the goal}

\item{goal_depth_to_circle}{The distance from the back tip of the goal to the
outer radius of the goal circle}
}
\value{
A data frame containing the bounding coordinates of the goal circle
}
\description{
The goal circle is a circular feature on the field that houses the goal line
(see \code{\link[=lacrosse_goal_line]{lacrosse_goal_line()}}) and the goal. Notably, for fields with a
surrounding arc and/or fan around the goal area, this feature \emph{only}
circumscribes the goal. Those features will be handled separately. This
feature may either be the full circle (e.g. all 360 degrees), or a partial
circle that may be greater than a half-circle
}
\keyword{internal}
