% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geniusR.R
\name{get_album_data}
\alias{get_album_data}
\title{Retrieve artist discography with song lyrics and audio info}
\usage{
get_album_data(artist, albums = character(),
  authorization = get_spotify_access_token())
}
\arguments{
\item{artist}{The quoted name of the artist. Spelling matters, capitalization does not.}

\item{albums}{A character vector of album names. Spelling matters, capitalization does not}

\item{authorization}{Authorization token for Spotify web API. Defaults to \code{get_spotify_access_token()}}
}
\description{
Retrieve the entire discography of an artist with the lyrics of each song and the associated audio information. Returns the song data as a nested tibble. This way we can easily see each album, artist, and song title before expanding our data.
}
\examples{
\dontrun{
get_album_data("Wild child", "Expectations")
}

}
