% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/browse.R
\name{get_recommendations_all}
\alias{get_recommendations_all}
\title{Get Recommendations for Unlimited Vector of Track IDs}
\usage{
get_recommendations_all(track_ids, valence = NULL)
}
\arguments{
\item{track_ids}{A vector containing the IDs of the tracks you'd like recommendations for}

\item{valence}{The target valence for the recommendations}
}
\value{
Returns a data frame containing binded recommendations from the Spotify API in a
single data frame.
}
\description{
Get recommendations for a submitted vector of track IDs, with no limit on the number of seed tracks
}
\details{
This is a wrapper for the \code{\link{get_recommendations}} function, which provides a workaround for
the limit of 5 seed tracks per recommendation call. The function splits a supplied vector
of track IDs into subsets of length 5, then applies a  \code{\link{get_recommendations}} call,
5 tracks at a time. This should generate a data frame of recommended tracks, with
length equal to the supplied vector of track ids.
}
\examples{
\donttest{
get_recommendations_all(
   track_ids = c("5VIpLopHgolKcSSj7JPCMA", "3QRGYDFFUVb4qneE4DX1gR")
   )
}
}
\seealso{
Other personalization functions: 
\code{\link{get_my_top_artists_or_tracks}()},
\code{\link{get_recommendations}()}
}
\concept{personalization functions}
