% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_spotoroo.R
\name{plot_spotoroo}
\alias{plot_spotoroo}
\title{Plotting spatiotemporal clustering result}
\usage{
plot_spotoroo(
  result,
  type = "def",
  cluster = "all",
  hotspot = TRUE,
  noise = FALSE,
  ignition = TRUE,
  from = NULL,
  to = NULL,
  step = 1,
  mainBreak = NULL,
  minorBreak = NULL,
  dateLabel = NULL,
  bg = NULL
)
}
\arguments{
\item{result}{\code{spotoroo} object. A result of a call to \code{\link[=hotspot_cluster]{hotspot_cluster()}}.}

\item{type}{Character. Type of the plot. One of "def" (default),
"timeline" (timeline) and "mov" (fire movement).}

\item{cluster}{Character/Integer. If "all", plot all clusters. If an integer
vector is given, plot corresponding clusters. Unavailable in
\code{\link[=plot_timeline]{plot_timeline()}}.}

\item{hotspot}{Logical. If \code{TRUE}, plot the hot spots. Unavailable in
\code{\link[=plot_timeline]{plot_timeline()}}.}

\item{noise}{Logical. If \code{TRUE}, plot the noise. Only used in
\code{\link[=plot_def]{plot_def()}}.}

\item{ignition}{Logical. If \code{TRUE}, plot the ignition points. Only used in
\code{\link[=plot_def]{plot_def()}}.}

\item{from}{\strong{OPTIONAL}. Date/Datetime/Numeric. Start time. The data type
needs to be the same as the provided observed time.}

\item{to}{\strong{OPTIONAL}. Date/Datetime/Numeric. End time. The data type
needs to be the same as the provided observed time.}

\item{step}{Integer (>=0). Step size used in the calculation of the
fire movement. Only used in \code{\link[=plot_fire_mov]{plot_fire_mov()}}.}

\item{mainBreak}{\strong{OPTIONAL}. Character/Numeric. A string/value giving the
difference between major breaks. If the
observed time is in date/datetime
format,
this value will be passed to
\code{\link[ggplot2:scale_date]{ggplot2::scale_x_date()}} or
\code{\link[ggplot2:scale_date]{ggplot2::scale_x_datetime()}} as
\code{date_breaks}. Only used in
\code{\link[=plot_timeline]{plot_timeline()}}.}

\item{minorBreak}{\strong{OPTIONAL}. Character/Numeric. A string/value giving the
difference between minor breaks. If the
observed time is in date/datetime
format,
this value will be passed to
\code{\link[ggplot2:scale_date]{ggplot2::scale_x_date()}} or
\code{\link[ggplot2:scale_date]{ggplot2::scale_x_datetime()}} as
\code{date_minor_breaks}. Only used in
\code{\link[=plot_timeline]{plot_timeline()}}.}

\item{dateLabel}{\strong{OPTIONAL}. Character. A string giving the formatting
specification for the labels. If the
observed
time is in date/datetime format,
this value will be passed to
\code{\link[ggplot2:scale_date]{ggplot2::scale_x_date()}} or
\code{\link[ggplot2:scale_date]{ggplot2::scale_x_datetime()}} as
\code{date_labels}. Unavailable if the observed
time is in numeric format. Only used in
\code{\link[=plot_timeline]{plot_timeline()}}.}

\item{bg}{\strong{OPTIONAL}. \code{ggplot} object. If specified, plot onto this object.
Unavailable in \code{\link[=plot_timeline]{plot_timeline()}}.}
}
\value{
A \code{ggplot} object. The plot of the clustering results.
}
\description{
This function takes a \code{spotoroo} object to produce a plot of the
clustering results. It can be called by \code{\link[=plot.spotoroo]{plot.spotoroo()}}.
}
\details{
if \code{type} is "def", the clustering results will be plotted spatially.
See also \code{\link[=plot_def]{plot_def()}}. Available arguments:
\itemize{
\item \code{result}
\item \code{type}
\item \code{cluster}
\item \code{ignition}
\item \code{hotspot}
\item \code{noise}
\item \code{from} (\strong{OPTIONAL})
\item \code{to} (\strong{OPTIONAL})
\item \code{bg} (\strong{OPTIONAL})
}

if \code{type} is "mov", plot of the fire movement will be made.
See also \code{\link[=plot_fire_mov]{plot_fire_mov()}}. Available arguments:
\itemize{
\item \code{result}
\item \code{type}
\item \code{cluster}
\item \code{hotspot}
\item \code{from} (\strong{OPTIONAL})
\item \code{to} (\strong{OPTIONAL})
\item \code{step}
\item \code{bg} (\strong{OPTIONAL})
}

if \code{type} is "timeline", plot of the timeline will be made.
See also \code{\link[=plot_timeline]{plot_timeline()}}. Available arguments:
\itemize{
\item \code{result}
\item \code{type}
\item \code{from} (\strong{OPTIONAL})
\item \code{to} (\strong{OPTIONAL})
\item \code{mainBreak} (\strong{OPTIONAL})
\item \code{minorBreak} (\strong{OPTIONAL})
\item \code{dateLabel} (\strong{OPTIONAL})
}
}
\examples{
\donttest{

  # Time consuming functions (>5 seconds)


  # Get clustering result
  result <- hotspot_cluster(hotspots,
                          lon = "lon",
                          lat = "lat",
                          obsTime = "obsTime",
                          activeTime = 24,
                          adjDist = 3000,
                          minPts = 4,
                          minTime = 3,
                          ignitionCenter = "mean",
                          timeUnit = "h",
                          timeStep = 1)

  # Different types of plots

  # Default plot
  plot_spotoroo(result, "def", bg = plot_vic_map())


  # Fire movement plot
  plot_spotoroo(result, "mov", cluster = 1:3, step = 3,
                bg = plot_vic_map())
}


}
