% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{BivariateMoransIStats}
\alias{BivariateMoransIStats}
\title{Bivariate Moran's I statistics}
\usage{
BivariateMoransIStats(X, W)
}
\arguments{
\item{X}{A matrix with observations as rows and features as columns.}

\item{W}{A weight matrix across all observations, i.e inverse of a pairwise distance matrix.}
}
\value{
A list containing the following:
\itemize{
\item E.I, the expectation of Moran's I under the null hypothesis.
\item SD.I, the standard deviation of Moran's I under the null hypothesis.
}
}
\description{
Calculate theoretical expectation and standard deviation of bivariate Moran's I under the null hypothesis.
}
\examples{
{
data.use <- quakes[1:100,]
W <- 1/as.matrix(dist(data.use[,1:2]))
diag(W) <- 0
res <- BivariateMoransIStats(data.use[,3:4], W)
}
}
\references{
Czaplewski, R. L. Expected Value and Variance of Moran’s Bivariate Spatial Autocorrelation Statistic for a Permutation Test.
(U.S. Department of Agriculture, Forest Service, Rocky Mountain Forest and Range Experiment Station, 1993).
}
\concept{stats}
