% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moransi.R
\name{FitMoransI}
\alias{FitMoransI}
\title{Fitted values of Moran's I}
\usage{
FitMoransI(X, Y, I, all = FALSE)
}
\arguments{
\item{X}{A matrix with observations as rows and features as columns.}

\item{Y}{A matrix of spatial lags.}

\item{I}{A matrix of Moran's I, output by \code{\link[spots]{OLSMoransI}}..}

\item{all}{Whether to use multivariate Moran's I, default is \code{FALSE}.}
}
\value{
A list containing the following:
\itemize{
\item residuals, residuals of fitted Moran's I.
\item fitted.values, fitted values of Moran's I.
\item all.fitted.values, a three-dimensional tensor of all fitted multivariate Moran's I, if calculated.
\item all.residuals, a three-dimensional tensor of all residuals using fitted multivariate Moran's I, if calculated.
}
}
\description{
Calculate fitted values of Moran's I as linear regression.
}
\examples{
{
data.use <- quakes[1:100,]
W <- 1/as.matrix(dist(data.use[,1:2]))
diag(W) <- 0
res <- OLSMoransI(data.use[,3:4], W)
res.fitted <- FitMoransI(res$X, res$Y, res$Morans.I)
}
}
\references{
Anselin, L. Local indicators of spatial association-LISA. Geogr. Anal. 27, 93–115 (2010)
}
\concept{moransi}
