% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hnn.R
\name{HnnImpute}
\alias{HnnImpute}
\title{Hexagonal nearest neighbor based imputation}
\usage{
HnnImpute(data, dist.hnn, dist.k = NULL, mu = 0, sigma = 1)
}
\arguments{
\item{data}{A data matrix with features as rows and observations as columns.}

\item{dist.hnn}{A hexagonal nearest neighbor distance matrix.}

\item{dist.k}{The maximum distance used to calculate the weight. Default is \code{NULL} and all neighbor weights are calculated.}

\item{mu}{The mean of Gaussian filter, default is 0.}

\item{sigma}{The standard deviation of Gaussian filter, default is 1.}
}
\value{
Imputed data.
}
\description{
Data imputation and smoothing using hexagonal nearest neighbor.
}
\examples{
{
data.use <- quakes[1:100,]
dist.use <- as.matrix(dist(data.use[,1:2]))
# transpose the data to have features in rows and observations in columns
res <- HnnImpute(t(data.use[,3:4]), dist.use)
}

}
\seealso{
\code{\link[spots]{HnnWeight}}
}
\concept{hnn}
