% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sca.R
\name{LeeL}
\alias{LeeL}
\title{Bivariate Moran's I using Lee's L measurement}
\usage{
LeeL(X, W)
}
\arguments{
\item{X}{A matrix with observations as rows and features as columns.}

\item{W}{A weight matrix across all observations, i.e inverse of a pairwise distance matrix.}
}
\value{
A spatial cross-correlation matrix.
}
\description{
Calculate bivariate Moran's I using Lee's L measurement.
}
\examples{
{
data.use <- quakes[1:100,]
W <- 1/as.matrix(dist(data.use[,1:2]))
diag(W) <- 0
L <- LeeL(data.use[,3:4], W)
}
}
\references{
Lee, S.-I. Developing a bivariate spatial association measure:
An integration of Pearson’s r and Moran's I. J. Geogr. Syst. 3, 369–385 (2001)
}
\concept{sca}
