% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{PermutationPval}
\alias{PermutationPval}
\title{Permutation based p-value}
\usage{
PermutationPval(
  x,
  X.perm,
  alternative = c("two.sided", "less", "greater"),
  p.adjust.method = "BH",
  condition = 0
)
}
\arguments{
\item{x}{A numerical vector.}

\item{X.perm}{A matrix contains permutation result of x.}

\item{alternative}{Alternative hypothesis used, default is \code{two.sided}.}

\item{p.adjust.method}{Method used for multiple comparisons correction, default is \code{BH}. See \code{\link[stats]{p.adjust}}.}

\item{condition}{Value under null hypothesis to compare with, default is 0.}
}
\value{
A list containing the following:
\itemize{
\item p.val, permutation based p-value.
\item p.adj, adjusted p-values.
}
}
\description{
Calculate permutation based p-values.
}
\keyword{internal}
