% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normmix_plots.R
\name{plot_density}
\alias{plot_density}
\title{Plots a density or image}
\usage{
plot_density(density_df, contour = FALSE, grayscale = FALSE, pp = NULL,
  surf = NULL, main = "2d surface (density or intensity)")
}
\arguments{
\item{density_df}{A data frame. Typically density_df=as.data.frame(imdens), where imdens an \code{\link[spatstat]{im}} object.}

\item{contour}{Logical flag requesting the countour plot only.}

\item{grayscale}{Plot in gray scale. Default is FALSE (use colors).}

\item{pp}{Optional point pattern to display (a \code{\link[spatstat]{ppp}} or \code{sppmix} object).}

\item{surf}{Optional \code{intensity_surface} object containing means to be displayed in the plot.}

\item{main}{A title for the 2d plot.}
}
\description{
Create a 2d image or contour plot of the density, intensity or any
image object.

For examples see

\url{http://www.stat.missouri.edu/~amicheas/sppmix/sppmix_all_examples.html
#plot_density}
}
\details{
This function does not open a new window for the plot.
}
\examples{

\dontrun{
# plot a mixture of normals density
truemix <- rnormmix(m = 3, sig0 = .1, df = 5, xlim= c(0, 5), ylim = c(0, 5))
summary(truemix)
normdens=dnormmix(truemix, xlim = c(0, 5), ylim = c(0, 5))
#2d plots
plot_density(normdens, main="2d mixture density plot\\nWindow=[0,5]x[0,5]")
#Contour plot
plot_density(normdens, contour=TRUE, main="2d mixture contour plot\\nWindow=[0,5]x[0,5]")}

}
\author{
Sakis Micheas
}
\seealso{
\code{\link{dnormmix}}
}

