% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normmix_plots.R
\name{plot.sppmix}
\alias{plot.sppmix}
\title{Plot a spatial point pattern}
\usage{
\method{plot}{sppmix}(x, mus, estcomp, open_new_window = FALSE,
  colors = FALSE, showmarks = FALSE, ...)
}
\arguments{
\item{x}{A point pattern of class \code{\link{sppmix}} or
\code{\link[spatstat]{ppp}}.}

\item{mus}{An optional list of the theoretical means of the mixture components.}

\item{estcomp}{The estimated component label should be a vector whose length
should be the same as number of points. If \code{estcomp} is not missing, the function will plot the
points using different colors according to \code{estcomp}. See the example on how
to calculate \code{estcomp} from a DAMCMC fit. If this variable is missing and we
pass a point pattern generated using \code{rsppmix}, then the true component labels will be used, otherwise,
the function will not plot the points with different colors to indicate the different components.}

\item{open_new_window}{Open a new window for the plot.}

\item{colors}{Logical flag requesting to use different colors for the points based
on which component they belong to.}

\item{showmarks}{Logical flag requesting
to plot each point with a different circle size
according to its mark value.}

\item{...}{Additional parameters to the \code{add_title} function. Valid choices
are m, n and L. To add a different title than the default, use \code{add_title} after the plot call (see examples below).}
}
\description{
Plot a spatial point pattern generated from a Poisson with
mixture intensity surface. Alternatively, the function can
plot a spatstat \code{\link[spatstat]{ppp}} object.

For examples see

\url{http://www.stat.missouri.edu/~amicheas/sppmix/sppmix_all_examples.html
#plot.sppmix}
}
\examples{

\dontrun{
mix1 <- rnormmix(5, sig0 = .01, df = 5, xlim=c(0, 5), ylim=c(0, 5))
intsurf1=to_int_surf(mix1, lambda = 40, win =spatstat::owin( c(0, 5),c(0, 5)))
pp1 <- rsppmix(intsurf1)
plot(pp1)
plot(pp1, mus=intsurf1$mus)
plot(pp1,mus=intsurf1$mus)+add_title(
 "Poisson point pattern along with the true component means", m=intsurf1$m,n=pp1$n)
plot(pp1, mus = intsurf1$mus, lambda = intsurf1$lambda)
plot(pp1, mus = intsurf1$mus)+ add_title(
 "Poisson point pattern along with the true component means", lambda = intsurf1$lambda,
 m=intsurf1$m,n=pp1$n)
#use the demo intensity surface
demo_intsurf
pp2 <- rsppmix(demo_intsurf)
plot(pp2)
plot(pp2, mus = demo_intsurf$mus)#plot the mixture means as well
#plot the points with different colors depending on the true component label
plot(pp2, colors = TRUE)
#plot the points with different colors depending on the estimated component label
fit <- est_mix_damcmc(pp2, 2)
est_comp <- GetMAPLabels(fit)
plot(pp2, estcomp = est_comp, colors = TRUE)
#generate and plot a marked point pattern
newMPP=rMIPPP_cond_mark()
plot(newMPP$genMPP, showmarks=TRUE)}

}
\author{
Jiaxun Chen, Sakis Micheas, Yuchen Wang
}
\seealso{
\code{\link{normmix}},
\code{\link{to_int_surf}},
\code{\link[spatstat]{owin}},
\code{\link{rsppmix}},
\code{\link{est_mix_damcmc}},
\code{\link{GetMAPLabels}},
\code{\link{rMIPPP_cond_mark}}
}

