% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/springer.R
\name{springer}
\alias{springer}
\title{fit the model with given tuning parameters}
\usage{
springer(
  clin = NULL,
  e,
  g,
  y,
  beta0,
  func,
  corr,
  structure,
  lam1,
  lam2,
  maxits = 30,
  tol = 0.001
)
}
\arguments{
\item{clin}{a matrix of clinical covariates. The default value is NULL. Whether to include the clinical covariates is decided by user.}

\item{e}{a matrix of environment factors.}

\item{g}{a matrix of genetic factors.}

\item{y}{the longitudinal response.}

\item{beta0}{the initial coefficient vector}

\item{func}{the framework to obtain the score equation.  Two choices are available: "GEE" and "QIF".}

\item{corr}{the working correlation structure adopted in the estimation algorithm. The springer provides three choices for the
working correlation structure: exchangeable, AR-1,and independence.}

\item{structure}{Three choices are available for structured variable selection. "bilevel" for sparse-group selection on both group-level and individual-level. "group" for selection on group-level only. "individual" for selection on individual-level only.}

\item{lam1}{the tuning parameter \eqn{\lambda_1} for individual-level penalty applied to genetic factors.}

\item{lam2}{the tuning parameter \eqn{\lambda_2} for group-level penalty applied to gene-environment interactions.}

\item{maxits}{the maximum number of iterations that is used in the estimation algorithm. The default value is 30.}

\item{tol}{The tolerance level. Coefficients with absolute values that are smaller than the tolerance level will be set to zero. The adhoc value can be chosen as 0.001.}
}
\value{
\item{coef}{the coefficient vector.}
}
\description{
This function performs penalized variable selection for longitudinal data based on generalized estimating equation (GEE) or quadratic inference functions (QIF) with a given value of lambda.
Typical usage is to first obtain the optimal lambda using cross validation, then provide it to the springer function.
}
\details{
Look back to the data model described in "\code{\link{dat}}":
 \deqn{Y_{ij}= \alpha_0 + \sum_{m=1}^{t}\theta_m Clin_{ijm} + \sum_{u=1}^{q}\alpha_u E_{iju} + \sum_{v=1}^{p}\eta_v^\top Z_{ijv}+\epsilon_{ij},}
where \eqn{Z_{ijv}} contains the \eqn{v}th genetic main factor and its interactions with the \eqn{q} environment factors for the \eqn{j}th measurement on the \eqn{i}th subject
and \eqn{\eta_{v}} is the corresponding coefficient vector of length \eqn{1+q}.

When {structure="bilevel"}, variable selection for genetic main effects and gene-environment interactions under the longitudinal response will be conducted on both individual and group levels (bi-level selection):
\itemize{
\item \strong{Group-level selection:} by determining whether \eqn{||\eta_{v}||_{2}=0}, we can know if the \eqn{v}th genetic variant has any effect at all.
\item \strong{Individual-level selection:} investigate whether the \eqn{v}th genetic variant has main effect, G\eqn{\times}E interaction or both, by determining which components in \eqn{\eta_{v}} has non-zero values.
}
If {structure="group"}, only group-level selection will be conducted on \eqn{||\eta_{v}||_{2}}; if {structure="individual"}, only individual-level selection will be conducted on each \eqn{\eta_{vu}}, (\eqn{u=1,\ldots,q}).

This function also provides choices for the framework that is used.  If {func="QIF"}, variable selection will be conducted within the quadratic inference functions framework; if {func="GEE"}, variable selection will be
conducted within the generalized estimating equation framework.

There are three options for the choice of the working correlation.  If {corr="exchangeable"}, the exchangeable working correlation will be applied; if {corr="AR-1"}, the AR-1 working correlation will be adopted; if {corr="independence"},
the independence working correlation will be used.
Please check the references for more details.
}
\examples{
data("dat")
##load the clinical covariates, environment factors, genetic factors and response from the
##"dat" file
clin=dat$clin
if(is.null(clin)){t=0} else{t=dim(clin)[2]}
e=dat$e
u=dim(e)[2]
g=dat$g
y=dat$y
##initial coefficient
beta0=dat$coef
##true nonzero coefficients
index=dat$index
beta = springer(clin=clin, e, g, y,beta0,func="GEE",corr="independence",structure="bilevel",
lam1=dat$lam1, lam2=dat$lam2,maxits=30,tol=0.01)
##only focus on the genetic main effects and gene-environment interactions
beta[1:(1+t+u)]=0
##effects that have nonzero coefficients
pos = which(beta != 0)
##true positive and false positive
tp = length(intersect(index, pos))
fp = length(pos) - tp
list(tp=tp, fp=fp)

}
