% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numMualem.R
\name{numMualem}
\alias{numMualem}
\title{Function to Numerically Compute the Mualem Integral}
\usage{
numMualem(h, scap, pcon = NA)
}
\arguments{
\item{h}{vector of length \code{l} pressure head values.}

\item{scap}{Capillary saturation [cm3 cm-3].}

\item{pcon}{vector of soil hydraulic conductivity model parameters, the first argument is \code{q} and the second \code{r}.}
}
\value{
returns a vector of length \code{l} of calulcated conductivity values at \code{h}.
}
\description{
This function will calculate numerically Mualems Integral \insertCite{Mualem.1976}{spsh} and return Hydraulic Conductivity Values.
}
\details{
The numerical solution of Mualems integral relies on the trapezoidal rul of integration.
}
\examples{
h <- 10^seq(-3, 6.8, length = 501)
p = c(.05, .5, .01, 1.8, 100, .5)
shyp.L <- shypFun.01110(p, h)

Ks <- p[5]
tau <- p[6]
Se <- shyp.L[['Se']]
Khrnum <- numMualem(h, pcon = tau, scap = Se) 

Khnum <- Ks * Se^tau * Khrnum

plot(log10(h), log10(shyp.L[['Kh']]), ylim = c(-10, 2.3), 
     xlim = c(-1,6), ylab = "log10 Kunsat [ cm/d ]", xlab = "pF [ - ]", type = "l", lwd = 8)
lines(log10(h), log10(Khnum), col = "red", lwd = 2)
}
\references{
\insertRef{Mualem.1976}{spsh}
}
\author{
Tobias KD Weber , \email{tobias.weber@uni-hohenheim.de}
}
