% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ptf.vG2BW.R
\name{ptf.vG2BW}
\alias{ptf.vG2BW}
\title{Parameter Transfer Function for Weber et al.(2019) model.}
\usage{
ptf.vG2BW(x)
}
\arguments{
\item{x}{vector of 6 van Genuchten-Model parameters. The order is sensitive see for \code{\link[spsh]{shypFun.01110}}
\tabular{lll}{
    \code{thr}\tab{Residual water content (-), alway equal to zero}\cr
    \code{ths}\tab{Saturated water content (-)}\cr
    \code{alf1}\tab{Shape parameter (cm^-1)}\cr
    \code{n1}\tab{Shape parameter (-)}\cr
    \code{Ks}\tab{Hydraulic conductivity at 0 potential (cm/day)}\cr
    \code{tau}\tab{Shape parameter (-)}\cr
 }}
}
\value{
\tabular{lll}{
     \code{thsnc}\tab{Saturated water content of the non-capillary part.}\cr
     \code{thsc}\tab{Saturated water content of the capillary part.}\cr
     \code{alf}\tab{Shape parameter (cm^-1)}\cr
     \code{n}\tab{Shape parameter (-)}\cr
     \code{Ksc}\tab{Saturated hydraulic conductivity of the capillary part [cm day-1]}\cr
     \code{tau}\tab{Shape parameter (-)}\cr
     \code{Ksnc}\tab{Saturated hydraulic conductivity of the non-capillary part [cm day-1]}\cr
     \code{a}\tab{slope of the non-capillary unsaturated conductivity [ - ]}\cr
     \code{h0}\tab{anker point at which the water content is 0}
     }
}
\description{
Predicts \insertCite{Weber.2019}{spsh} model parameters in the van Genuchten-Mualem variant \emph{01110FM}, from given van Genuchten-Mualem parameters 
for the constrained van Genuchten-Mualem model.
}
\details{
Pedotransfer function returns the van Genuchten - Mualem model \code{\link[spsh]{shypFun.01110}} parameters in the Brunswick-Model variant \emph{01110FM}, based on previously determined van Genuchten-Mualem parameters. The transfer function is based on an ordinary linear regression between the i-th \emph{01110} and \emph{01110FM}. The paraemeters
were based on model parameter estimation to a dataset of >400 samples with retention and conductivity measurements.
}
\note{
The parameter transfer function was derived by weighted linear regression with weights in \code{x} and \code{y}, 
by regressing the estimated the Brunswick model parameters in the Genuchten Mualem variant \insertCite{Weber.2019}{spsh} 
inferred from matching measured soil water retention and hydraulic conductivity data against the constrained van Genuchten model parameters. 
The regression of \code{alf1} and \code{Ks}, and \code{(n-1)} was done in the \code{log[10])}-transformed space,
and \code{Kncs} is a fixed value of 10^-1.72.
}
\examples{
p      <- c(0.08, 0.42, 0.01, 1.5, 100, 0.5)
result <- ptf.vG2BW(p)

}
\seealso{
\code{\link[spsh]{shypFun}}
}
\author{
Efstathios Diamantopoulos , \email{ed@plen.ku.dk}

Tobias KD Weber , \email{tobias.weber@uni-hohenheim.de}
}
