% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sncFun.04110.R
\name{sncFun.04110}
\alias{sncFun.04110}
\title{Unimodal Brooks-Corey Non-Capillary Saturation Model}
\usage{
sncFun.04110(p_snc, h)
}
\arguments{
\item{p_snc}{vector of the 2 Brooks-Corey model parameters, order is sensitve and has to be given as:
\tabular{lll}{
      \code{alf}\tab{air entry pressure head [cm^-1]}\cr
      \code{bet}\tab{effective model parameter [ - ]}\cr
      \code{h0}\tab{pressure head representing oven dryness given in pF, i.e. log[10](|pressure head| [cm])}\cr
         }}

\item{h}{pressure heads [cm] for which the corresponding retention and conductivity values are calculated.}
}
\value{
returns a \code{list} with calculations at specified \code{h}:
\item{snc}{non-capillary saturation}
}
\description{
Analytical implementation of the non-capillary saturation function from the Brooks-Corey function \insertCite{Brooks.1964}{spsh}.
}
\details{
The function is Eq. Table 1-A  in insertRef{Streck.2020}{spsh}
The analytical solution presented in \code{sncFun.04110} only requires the Brooks-Corey model specific parameters and \code{h0}.
}
\examples{
p     <- c(0.1, 0.4, .02, 2, 100, .5)
p_snc <- c(p[3:4], 6.8)
h     <- 10^seq(-2, 6.8, length = 197)
Se    <- shypFun.04110(p, h)$Se
snc   <- sncFun.04110(p_snc, h)
}
\references{
\insertRef{Brooks.1964}{spsh}
\insertRef{Streck.2020}{spsh}
}
