% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjwgt.R
\name{adjwgt}
\alias{adjwgt}
\title{Adjust survey design weights by categories}
\usage{
adjwgt(wgt, wgtcat = NULL, framesize, sites = NULL)
}
\arguments{
\item{wgt}{Vector of initial weights for each site. These equal
the reciprocal of the site's inclusion probability.}

\item{wgtcat}{Vector containing each site's weight adjustment
category name. The default is \code{NULL}, which assumes every
site is in the same category.}

\item{framesize}{Vector containing the known size of the frame
for each category name in \code{wgtcat}. If \code{wgtcat} is provided,
the names in \code{framesize} must match the names in \code{wgtcat}.
If \code{wgtcat} is not provided, an unnamed scalar is given to
\code{framesize}.}

\item{sites}{Vector indicating site use; \code{TRUE} indicates the site
should be included in the weight adjustment and \code{FALSE} indicates
the site should not be included in the weight adjustment. The default is
\code{NULL}, which assumes every site should be included.}
}
\value{
Vector of adjusted weights, where the adjusted weight is set
  to \code{0} for sites whose value in the sites argument was set to
  \code{FALSE}.
}
\description{
Adjust initial survey design weights so that the
final weights sum to a desired frame size. Adjusted weights
proportionally scale the initial weights to sum to the desired frame size.
Separate adjustments are applied to each category specified in \code{wgtcat}.
}
\examples{
wgt <- runif(50)
wgtcat <- rep(c("A", "B"), c(30, 20))
framesize <- c(A = 15, B = 10)
sites <- rep(rep(c(TRUE, FALSE), c(9, 1)), 5)
adjwgt(wgt, wgtcat, framesize, sites)
}
\author{
Tony Olsen \email{olsen.tony@epa.gov}
}
\keyword{misc}
\keyword{survey}
