% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/change_analysis.R
\name{change_analysis}
\alias{change_analysis}
\title{Change analysis}
\usage{
change_analysis(
  dframe,
  vars_cat = NULL,
  vars_cont = NULL,
  test = "mean",
  subpops = NULL,
  surveyID = "surveyID",
  survey_names = NULL,
  siteID = "siteID",
  weight = "weight",
  revisitwgt = FALSE,
  xcoord = NULL,
  ycoord = NULL,
  stratumID = NULL,
  clusterID = NULL,
  weight1 = NULL,
  xcoord1 = NULL,
  ycoord1 = NULL,
  sizeweight = FALSE,
  sweight = NULL,
  sweight1 = NULL,
  fpc = NULL,
  popsize = NULL,
  vartype = "Local",
  jointprob = "overton",
  conf = 95,
  All_Sites = FALSE
)
}
\arguments{
\item{dframe}{Data to be analyzed (analysis data). A data frame or
\code{sf} object containing survey design variables, response
variables, and subpopulation (domain) variables.}

\item{vars_cat}{Vector composed of character values that identify the
names of categorical response variables in \code{dframe}.  The
default is \code{NULL}.}

\item{vars_cont}{Vector composed of character values that identify the
names of continuous response variables in \code{dframe}.  The
default is \code{NULL}.}

\item{test}{Character string or character vector providing the location
measure(s) to use for change estimation for continuous variables.  The
choices are \code{"mean"}, \code{"total"}, \code{"median"}, or some
combination of the three options (e.g., \code{c("mean", "total")}).
The default is \code{"mean"}.}

\item{subpops}{Vector composed of character values that identify the
names of subpopulation (domain) variables in \code{dframe}.
If a value is not provided, the value \code{"All_Sites"} is assigned to the
subpops argument and a factor variable named \code{"All_Sites"} that takes
the value \code{"All Sites"} is added to \code{dframe}.  The
default value is \code{NULL}.}

\item{surveyID}{Character value providing name of the survey ID variable in
\code{dframe}.  The default value is \code{"surveyID"}.}

\item{survey_names}{Character vector of length two that provides the survey
names contained in the \code{surveyID} variable in the \code{dframe} data
frame.  The two values in the vector identify the first survey and second
survey, respectively.  If a value is not provided, unique values of the
\code{surveyID} variable are assigned to the \code{survey_names} argument.
The default is \code{NULL}.}

\item{siteID}{Character value providing name of the site ID variable in
\code{dframe}.  For a two-stage sample, the site ID variable
identifies stage two site IDs.  The default value is \code{"siteID"}. If a
unique site is visited in both surveys, the corresponding \code{siteID}
should be the same for both entries.}

\item{weight}{Character value providing name of the design weight
variable in \code{dframe}.  For a two-stage sample, the
weight variable identifies stage two weights.  The default value is
\code{"weight"}.}

\item{revisitwgt}{Logical value that indicates whether each repeat visit
site has the same design weight in the two surveys, where
\code{TRUE} = the weight for each repeat visit site is the same and
\code{FALSE} = the weight for each repeat visit site is not the same.  When
this argument is \code{FALSE}, all of the repeat visit sites are assigned
equal weights when calculating the covariance component of the change
estimate standard error.  The default is \code{FALSE}.}

\item{xcoord}{Character value providing name of the x-coordinate variable in
\code{dframe}.  For a two-stage sample, the x-coordinate
variable identifies stage two x-coordinates.  Note that x-coordinates are
required for calculation of the local mean variance estimator.  If \code{dframe}
is an \code{sf} object, this argument is not required (as the geometry column
in \code{dframe} is used to find the x-coordinate). The default
value is \code{NULL}.}

\item{ycoord}{Character value providing name of the y-coordinate variable in
\code{dframe}.  For a two-stage sample, the y-coordinate
variable identifies stage two y-coordinates.  Note that y-coordinates are
required for calculation of the local mean variance estimator.  If \code{dframe}
is an \code{sf} object, this argument is not required (as the geometry column
in \code{dframe} is used to find the y-coordinate). The default
value is \code{NULL}.}

\item{stratumID}{Character value providing name of the stratum ID variable in
\code{dframe}.  The default value is \code{NULL}.}

\item{clusterID}{Character value providing the name of the cluster
(stage one) ID variable in \code{dframe}.  Note that cluster
IDs are required for a two-stage sample.  The default value is \code{NULL}.}

\item{weight1}{Character value providing name of the stage one weight
variable in \code{dframe}.  The default value is \code{NULL}.}

\item{xcoord1}{Character value providing the name of the stage one
x-coordinate variable in \code{dframe}.  Note that x
coordinates are required for calculation of the local mean variance
estimator.  The default value is \code{NULL}.}

\item{ycoord1}{Character value providing the name of the stage one
y-coordinate variable in \code{dframe}.  Note that
y-coordinates are required for calculation of the local mean variance
estimator.  The default value is \code{NULL}.}

\item{sizeweight}{Logical value that indicates whether size weights should be
used during estimation, where \code{TRUE} uses size weights and
\code{FALSE} does not use size weights. To employ size weights for a
single-stage sample, a value must be supplied for argument weight.  To
employ size weights for a two-stage sample, values must be supplied for
arguments \code{weight} and \code{weight1}. The default value is \code{FALSE}.}

\item{sweight}{Character value providing the name of the size weight variable
in \code{dframe}.  For a two-stage sample, the size weight
variable identifies stage two size weights.  The default value is
\code{NULL}.}

\item{sweight1}{Character value providing name of the stage one size weight
variable in \code{dframe}.  The default value is \code{NULL}.}

\item{fpc}{Object that specifies values required for calculation of the
  finite population correction factor used during variance estimation. The
  object must match the survey design in terms of stratification and whether
  the design is single-stage or two-stage.  For an unstratified design, the
  object is a vector.  The vector is composed of a single numeric value for a
  single-stage design.  For a two-stage unstratified design, the object is a
  named vector containing one more than the number of clusters in the sample,
  where the first item in the vector specifies the number of clusters in the
  population and each subsequent item specifies the number of stage two units
  for the cluster.  The name for the first item in the vector is arbitrary.
  Subsequent names in the vector identify clusters and must match the cluster
  IDs.  For a stratified design, the object is a named list of vectors, where
  names must match the strata IDs.  For each stratum, the format of the
  vector is identical to the format described for unstratified single-stage
  and two-stage designs.  Note that the finite population correction factor
  is not used with the local mean variance estimator.

  Example fpc for a single-stage unstratified survey design:

  \verb{fpc <- 15000}

  Example fpc for a single-stage stratified survey design:

  \verb{fpc <- list(
    Stratum_1 = 9000,
    Stratum_2 = 6000)
   }

  Example fpc for a two-stage unstratified survey design:

  \verb{fpc <- c(
    Ncluster = 150,
    Cluster_1 = 150,
    Cluster_2 = 75,
    Cluster_3 = 75,
    Cluster_4 = 125,
    Cluster_5 = 75)
  }

  Example fpc for a two-stage stratified survey design:

  \verb{fpc <- list(
    Stratum_1 = c(
      Ncluster_1 = 100,
      Cluster_1 = 125,
      Cluster_2 = 100,
      Cluster_3 = 100,
      Cluster_4 = 125,
      Cluster_5 = 50),
    Stratum_2 = c(
      Ncluster_2 = 50,
      Cluster_1 = 75,
      Cluster_2 = 150,
      Cluster_3 = 75,
      Cluster_4 = 75,
      Cluster_5 = 125))
  }}

\item{popsize}{Object that provides values for the population argument of the
  \code{calibrate} or \code{postStratify} functions in the survey package. If
  a value is provided for popsize, then either the \code{calibrate} or
  \code{postStratify} function is used to modify the survey design object
  that is required by functions in the survey package.  Whether to use the
  \code{calibrate} or \code{postStratify} function is dictated by the format
  of popsize, which is discussed below.  Post-stratification adjusts the
  sampling and replicate weights so that the joint distribution of a set of
  post-stratifying variables matches the known population joint distribution.
  Calibration, generalized raking, or GREG estimators generalize
  post-stratification and raking by calibrating a sample to the marginal
  totals of variables in a linear regression model. For the \code{calibrate}
  function, the object is a named list, where the names identify factor
  variables in \code{dframe}.  Each element of the list is a
  named vector containing the population total for each level of the
  associated factor variable.  For the \code{postStratify} function, the
  object is either a data frame, table, or xtabs object that provides the
  population total for all combinations of selected factor variables in the
  \code{dframe} data frame.  If a data frame is used for \code{popsize}, the
  variable containing population totals must be the last variable in the data
  frame.  If a table is used for \code{popsize}, the table must have named
  \code{dimnames} where the names identify factor variables in the
  \code{dframe} data frame.  If the popsize argument is equal to \code{NULL},
  then neither calibration nor post-stratification is performed.  The default
  value is \code{NULL}.

  Example popsize for calibration:

  \verb{popsize <- list(
    Ecoregion = c(
      East = 750,
      Central = 500,
      West = 250),
    Type = c(
      Streams = 1150,
      Rivers = 350))
  }

  Example popsize for post-stratification using a data frame:

  \verb{popsize <- data.frame(
    Ecoregion = rep(c("East", "Central", "West"),
      rep(2, 3)),
    Type = rep(c("Streams", "Rivers"), 3),
    Total = c(575, 175, 400, 100, 175, 75))
  }

  Example popsize for post-stratification using a table:

  \verb{popsize <- with(MySurveyFrame,
    table(Ecoregion, Type))}

  Example popsize for post-stratification using an xtabs object:

  \verb{popsize <- xtabs(~Ecoregion + Type,
    data = MySurveyFrame)}}

\item{vartype}{Character value providing the choice of the variance
estimator, where \code{"Local"} indicates the local mean estimator and
\code{"SRS"} indicates the simple random sampling estimator.  The default
value is \code{"Local"}.}

\item{jointprob}{Character value providing the choice of joint inclusion
probability approximation for use with Horvitz-Thompson and Yates-Grundy
variance estimators, where \code{"overton"} indicates the Overton
approximation, \code{"hr"} indicates the Hartley-Rao approximation, and
\code{"brewer"} equals the Brewer approximation.  The default value is
\code{"overton"}.}

\item{conf}{Numeric value providing the Gaussian-based confidence level.  The default value
is \code{95}.}

\item{All_Sites}{A logical variable used when \code{subpops} is not
\code{NULL}. If \code{All_Sites} is \code{TRUE}, then alongside the
subpopulation output, output for all sites (ignoring subpopulations) is
returned for each variable in \code{vars}. If \code{All_Sites} is
\code{FALSE}, then alongside the subpopulation output, output for all sites
(ignoring subpopulations) is not returned for each variable in \code{vars}.
The default is \code{FALSE}.}
}
\value{
List of change estimates composed of four items:
  (1) \code{catsum} contains change estimates for categorical variables,
  (2) \code{contsum_mean} contains estimates for continuous variables using
  the mean, (3) \code{contsum_total} contains estimates for continuous
  variables using the total, and (4) \code{contsum_median} contains estimates for continuous
  variables using the median.  The items in the list will contain \code{NULL}
  for estimates that were not calculated.  Each data frame includes estimates
  for all combinations of population Types, subpopulations within types,
  response variables, and categories within each response variable (for
  categorical variables and continuous variables using the median).  Change
  estimates are provided plus standard error estimates and confidence
  interval estimates.
  
  The \code{catsum} data frame contains the following variables:
  \describe{
    \item{Survey_1}{first survey name}
    \item{Survey_2}{second survey name}
    \item{Type}{subpopulation (domain) name}
    \item{Subpopulation}{subpopulation name within a domain}
    \item{Indicator}{response variable}
    \item{Category}{category of response variable}
    \item{DiffEst.P}{proportion difference estimate (in \%; second survey - first survey)}
    \item{StdError.P}{standard error of proportion difference estimate}
    \item{MarginofError.P}{margin of error of proportion difference estimate}
    \item{LCBxxPct.P}{xx\% (default 95\%) lower confidence bound of proportion difference estimate}
    \item{UCBxxPct.P}{xx\% (default 95\%) upper confidence bound of proportion difference estimate}
    \item{Estimate.U}{total difference estimate (second survey - first survey)}
    \item{StdError.U}{standard error of total difference estimate}
    \item{MarginofError.U}{margin of error of total difference estimate}
    \item{LCBxxPct.U}{xx\% (default 95\%) lower confidence bound of total difference estimate}
    \item{UCBxxPct.U}{xx\% (default 95\%) upper confidence bound of total difference estimate}
    \item{nResp_1}{sample size in the first survey}
    \item{Estimate.P_1}{proportion estimate (in \%) from the first survey}
    \item{StdError.P_1}{standard error of proportion estimate from the first survey}
    \item{MarginofError.P_1}{margin of error of proportion estimate from the first survey}
    \item{LCBxxPct.P_1}{xx\% (default 95\%) lower confidence bound of proportion estimate from the first survey}
    \item{UCBxxPct.P_1}{xx\% (default 95\%) upper confidence bound of proportion estimate from the first survey}
    \item{nResp_2}{sample size in the second survey}
    \item{Estimate.U_1}{total estimate from the first survey}
    \item{StdError.U_1}{standard error of total estimate from the first survey}
    \item{MarginofError.U_1}{margin of error of total estimate from the first survey}
    \item{LCBxxPct.U_1}{xx\% (default 95\%) lower confidence bound of total estimate from the first survey}
    \item{UCBxxPct.U_1}{xx\% (default 95\%) upper confidence bound of total estimate from the first survey}
    \item{Estimate.P_2}{proportion estimate (in \%) from the second survey}
    \item{StdError.P_2}{standard error of proportion estimate from the second survey}
    \item{MarginofError.P_2}{margin of error of proportion estimate from the second survey}
    \item{LCBxxPct.P_2}{xx\% (default 95\%) lower confidence bound of proportion estimate from the second survey}
    \item{UCBxxPct.P_2}{xx\% (default 95\%) upper confidence bound of proportion estimate from the second survey}
    \item{Estimate.U_2}{total estimate from the second survey}
    \item{StdError.U_2}{standard error of total estimate from the second survey}
    \item{MarginofError.U_2}{margin of error of total estimate from the second survey}
    \item{LCBxxPct.U_2}{xx\% (default 95\%) lower confidence bound of total estimate from the second survey}
    \item{UCBxxPct.U_2}{xx\% (default 95\%) upper confidence bound of total estimate from the second survey}
  }
  
  The \code{contsum_mean} data frame contains the following variables:
  \describe{
    \item{Survey_1}{first survey name}
    \item{Survey_2}{second survey name}
    \item{Type}{subpopulation (domain) name}
    \item{Subpopulation}{subpopulation name within a domain}
    \item{Indicator}{response variable}
    \item{Statistic}{value of percentile}
    \item{nResp}{sample size at or below \code{Value}}
    \item{DiffEst}{mean difference estimate}
    \item{StdError}{standard error of mean difference estimate}
    \item{MarginofError}{margin of error of mean difference estimate}
    \item{LCBxxPct}{xx\% (default 95\%) lower confidence bound of mean difference estimate}
    \item{UCBxxPct}{xx\% (default 95\%) upper confidence bound of mean difference estimate}
    \item{nResp_1}{sample size in the first survey}
    \item{Estimate_1}{mean estimate from the first survey}
    \item{StdError_1}{standard error of mean estimate from the first survey}
    \item{MarginofError_1}{margin of error of mean estimate from the first survey}
    \item{LCBxxPct_1}{xx\% (default 95\%) lower confidence bound of mean estimate from the first survey}
    \item{UCBxxPct_1}{xx\% (default 95\%) upper confidence bound of mean estimate from the first survey}
    \item{nResp_2}{sample size in the second survey}
    \item{Estimate_2}{mean estimate from the second survey}
    \item{StdError_2}{standard error of mean estimate from the second survey}
    \item{MarginofError_2}{margin of error of mean estimate from the second survey}
    \item{LCBxxPct_2}{xx\% (default 95\%) lower confidence bound of mean estimate from the second survey}
    \item{UCBxxPct_2}{xx\% (default 95\%) upper confidence bound of mean estimate from the second survey}
  }
  
  The \code{contsum_total} data frame contains the following variables:
  \describe{
    \item{Survey_1}{first survey name}
    \item{Survey_2}{second survey name}
    \item{Type}{subpopulation (domain) name}
    \item{Subpopulation}{subpopulation name within a domain}
    \item{Indicator}{response variable}
    \item{Statistic}{value of percentile}
    \item{nResp}{sample size at or below \code{Value}}
    \item{DiffEst}{total difference estimate}
    \item{StdError}{standard error of total difference estimate}
    \item{MarginofError}{margin of error of total difference estimate}
    \item{LCBxxPct}{xx\% (default 95\%) lower confidence bound of total difference estimate}
    \item{UCBxxPct}{xx\% (default 95\%) upper confidence bound of total difference estimate}
    \item{nResp_1}{sample size in the first survey}
    \item{Estimate_1}{total estimate from the first survey}
    \item{StdError_1}{standard error of total estimate from the first survey}
    \item{MarginofError_1}{margin of error of total estimate from the first survey}
    \item{LCBxxPct_1}{xx\% (default 95\%) lower confidence bound of total estimate from the first survey}
    \item{UCBxxPct_1}{xx\% (default 95\%) upper confidence bound of total estimate from the first survey}
    \item{nResp_2}{sample size in the second survey}
    \item{Estimate_2}{total estimate from the second survey}
    \item{StdError_2}{standard error of total estimate from the second survey}
    \item{MarginofError_2}{margin of error of total estimate from the second survey}
    \item{LCBxxPct_2}{xx\% (default 95\%) lower confidence bound of total estimate from the second survey}
    \item{UCBxxPct_2}{xx\% (default 95\%) upper confidence bound of total estimate from the second survey}
  }
  
  The \code{contsum_median} data frame contains the following variables:
  \describe{
    \item{Survey_1}{first survey name}
    \item{Survey_2}{second survey name}
    \item{Type}{subpopulation (domain) name}
    \item{Subpopulation}{subpopulation name within a domain}
    \item{Indicator}{response variable}
    \item{Category}{category of response variable}
    \item{DiffEst.P}{proportion above or below median difference estimate (in \%; second survey - first survey)}
    \item{StdError.P}{standard error of proportion above or below median difference estimate}
    \item{MarginofError.P}{margin of error of proportion above or below median difference estimate}
    \item{LCBxxPct.P}{xx\% (default 95\%) lower confidence bound of proportion above or below median difference estimate}
    \item{UCBxxPct.P}{xx\% (default 95\%) upper confidence bound of proportion above or below median difference estimate}
    \item{Estimate.U}{total above or below median difference estimate (second survey - first survey)}
    \item{StdError.U}{standard error of total above or below median difference estimate}
    \item{MarginofError.U}{margin of error of total above or below median difference estimate}
    \item{LCBxxPct.U}{xx\% (default 95\%) lower confidence bound of total above or below median difference estimate}
    \item{UCBxxPct.U}{xx\% (default 95\%) upper confidence bound of total above or below median difference estimate}
    \item{nResp_1}{sample size in the first survey}
    \item{Estimate.P_1}{proportion above or below median estimate (in \%) from the first survey}
    \item{StdError.P_1}{standard error of proportion above or below median estimate from the first survey}
    \item{MarginofError.P_1}{margin of error of proportion above or below median estimate from the first survey}
    \item{LCBxxPct.P_1}{xx\% (default 95\%) lower confidence bound of proportion above or below median estimate from the first survey}
    \item{UCBxxPct.P_1}{xx\% (default 95\%) upper confidence bound of proportion above or below median estimate from the first survey}
    \item{nResp_2}{sample size in the second survey}
    \item{Estimate.U_1}{total above or below median estimate from the first survey}
    \item{StdError.U_1}{standard error of total above or below median estimate from the first survey}
    \item{MarginofError.U_1}{margin of error of total above or below median estimate from the first survey}
    \item{LCBxxPct.U_1}{xx\% (default 95\%) lower confidence bound of total above or below median estimate from the first survey}
    \item{UCBxxPct.U_1}{xx\% (default 95\%) upper confidence bound of total above or below median estimate from the first survey}
    \item{Estimate.P_2}{proportion above or below median estimate (in \%) from the second survey}
    \item{StdError.P_2}{standard error of proportion above or below median estimate from the second survey}
    \item{MarginofError.P_2}{margin of error of proportion above or below median estimate from the second survey}
    \item{LCBxxPct.P_2}{xx\% (default 95\%) lower confidence bound of proportion above or below median estimate from the second survey}
    \item{UCBxxPct.P_2}{xx\% (default 95\%) upper confidence bound of proportion above or below median estimate from the second survey}
    \item{Estimate.U_2}{total above or below median estimate from the second survey}
    \item{StdError.U_2}{standard error of total above or below median estimate from the second survey}
    \item{MarginofError.U_2}{margin of error of total above or below median estimate from the second survey}
    \item{LCBxxPct.U_2}{xx\% (default 95\%) lower confidence bound of total above or below median estimate from the second survey}
    \item{UCBxxPct.U_2}{xx\% (default 95\%) upper confidence bound of total above or below median estimate from the second survey}
  }
}
\description{
This function organizes input and output for the estimation of change between two
samples (for categorical and continuous variables).  The analysis data,
\code{dframe}, can be either a data frame or a simple features (\code{sf}) object.  If an
\code{sf} object is used, coordinates are extracted from the geometry column in the
object, arguments \code{xcoord} and \code{ycoord} are assigned values
\code{"xcoord"} and \code{"ycoord"}, respectively, and the geometry column is
dropped from the object.
}
\examples{
# Categorical variable example for three resource classes
dframe <- data.frame(
  surveyID = rep(c("Survey 1", "Survey 2"), c(100, 100)),
  siteID = paste0("Site", 1:200),
  wgt = runif(200, 10, 100),
  xcoord = runif(200),
  ycoord = runif(200),
  stratum = rep(rep(c("Stratum 1", "Stratum 2"), c(2, 2)), 50),
  CatVar = rep(c("North", "South"), 100),
  All_Sites = rep("All Sites", 200),
  Resource_Class = sample(c("Good", "Fair", "Poor"), 200, replace = TRUE)
)
myvars <- c("CatVar")
mysubpops <- c("All_Sites", "Resource_Class")
change_analysis(dframe,
  vars_cat = myvars, subpops = mysubpops,
  surveyID = "surveyID", siteID = "siteID", weight = "wgt",
  xcoord = "xcoord", ycoord = "ycoord", stratumID = "stratum"
)
}
\seealso{
\describe{
  \item{\code{\link{trend_analysis}}}{ for trend analysis}
  }
}
\author{
Tom Kincaid \email{Kincaid.Tom@epa.gov}
}
\keyword{survey}
