% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sql_helpers.R
\name{quoteText2}
\alias{quoteText2}
\title{Add single quotes to strings using stringi::stri_join, useful for converting R strings into SQL formatted strings.}
\usage{
quoteText2(x, char_only = TRUE, excluded_chars = c("NULL"))
}
\arguments{
\item{x}{A string.}

\item{char_only}{TRUE/FALSE, if TRUE, adds quotes only if is.character(x) is TRUE.}

\item{excluded_chars}{A character vector, will not add quotes if a value is in excluded_chars.}
}
\value{
A string, with single quotes added to match SQL string formatting.
}
\description{
Add single quotes to strings using stringi::stri_join, useful for converting R strings into SQL formatted strings.
}
\examples{
quoteText2("Sample quotes.")
}
