% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{bfgs_update}
\alias{bfgs_update}
\title{(Damped) BFGS Hessian approximation}
\usage{
bfgs_update(
  hessian,
  old_y,
  new_y,
  old_gradient,
  new_gradient,
  constraint_adjustment = TRUE
)
}
\arguments{
\item{hessian}{\strong{Dense matrix}
of size \eqn{N \times N}{N x N}:\cr
Current approximation of the Hessian matrix, which is
updated by reference.\cr
Needs to be symmetric positive definite.\cr 
A common starting point for the \code{BFGS} algorithm is the identity matrix.}

\item{old_y, new_y, old_gradient, new_gradient}{\strong{Numeric vectors} 
of size \code{N}:\cr
parameters \bold{old_y},\bold{new_y} and\cr
corresponding gradients \bold{old_gradient},\bold{new_gradient}
from previous and current iteration.}

\item{constraint_adjustment}{\strong{Boolean}:\cr
Whether to enforce positive definiteness\cr
(mainly for constrained optimization).}
}
\value{
Nothing. Argument 'hessian' is updated by reference.
}
\description{
\code{BFGS} update for appromation of the Hessian matrix
\insertCite{@cf. @broyden70; @fletcher70; @goldfarb70; @shanno70}{sqp}
in its damped version proposed by \insertCite{powell78;textual}{sqp}.
The approximation is based on first-order information  
(parameter values & gradients) only.
}
\references{
\insertAllCited{}
}
