% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config_files.R
\name{find_config_files}
\alias{find_config_files}
\title{Locate candidate configuration files}
\usage{
find_config_files(
  basenames = .basename.defaults(),
  dirs = .dir.defaults(),
  suffices = .suffix.defaults()
)
}
\arguments{
\item{basenames}{A vector of file names (without directory or file type) to
use in searching for configuration files.}

\item{dirs}{A vector of directory names to use in searching for configuration
files.}

\item{suffices}{A vector of suffices (file "type"s) to use in searching for
the configuration file.}
}
\value{
A vector of path specifications, or an empty vector if none are
found.
}
\description{
Given vectors of directories, basenames, and suffices,
combine them to find existing files.
}
\details{
This function is intended to support a variety of installation patterns, so
it attempts to be flexible in looking for configuration files.  First,
environment variables of the form \emph{basename}\verb{_CONFIG}, where
\emph{basename} is the uppercase form of each candidate basename, are
examined to see whether any translate to a file path.

Following this, the path name parts supplied as arguments are used to
build potential file names.  If \code{dirs} is not specified, the
following directories are checked by default:
\enumerate{
\item the user's \verb{$HOME} directory
\item the directory named \code{.srcr} (no leading \code{.} on Windows) under \verb{$HOME}
\item the directory in which the executing script is located
\item the directory in which the calling function's calling function's
source file is located (typically an application-level library). For
example, if the function \code{my_setup()} calls \code{\link[=srcr]{srcr()}}, which in turn calls
\code{\link[=find_config_files]{find_config_files()}}, then the directory of the file containing
\code{my_setup()} will be tried.
\item the directory in which the calling function's source file is located
(typically a utility function, such as \code{\link[=srcr]{srcr()}})
}

Note that the current working directory is not part of the search by
default.  This is done to limit the potential for accidentally introducing
(potentially harmful) configuration files by setting the working directory.

In each location, the file names given in \code{basenames} are checked; if
none are specified, several default file names are tried:
\enumerate{
\item the name of the calling function's source file
\item the name of the executing script
\item the directory in which the calling function's calling function's
source file is located (typically an application-level library).  For
example, if the function \code{my_setup()} calls \code{\link[=srcr]{srcr()}}, which in turn calls
\code{\link[=find_config_files]{find_config_files()}}, then the name of the file containing
\code{my_setup()} will be tried.
}

The suffices (file "type"s) of \code{.json}, \code{.conf}, and nothing,
are tried with each candidate path; you may override this default by
using the \code{suffices} parameter.  Finally, in order to accommodate the Unix
tradition of "hidden" configuration files, each basename is prefixed with
a period before trying the basename alone.
}
\examples{
\dontrun{
find_config_files() # All defaults
find_config_files(dirs = c(file.path(Sys.getenv('HOME'),'etc'),
                          '/usr/local/etc', '/etc'),
                 basenames = c('my_app'),
                 suffices = c('.conf', '.rc'))
}
}
