% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_index.r
\name{sample_index}
\alias{sample_index}
\title{Sample the biomass with observation error}
\usage{
sample_index(dat_list, outfile, fleets, years, sds_obs, make_plot = FALSE,
  write_file = TRUE)
}
\arguments{
\item{dat_list}{An SS data list object as read in from
\code{\link[r4ss]{SS_readdat}} in the \pkg{r4ss} package. Make sure
you select option \code{section=2}.}

\item{outfile}{A character string of the new file name to be created.
Must end in \code{.dat} or equal \code{wtatage.ss}.}

\item{fleets}{*A numeric vector giving the fleets to be used. This order also
pertains to other arguments. A missing value excludes that fleet from
\code{outfile} (i.e. it turns it off so no samples are written). If none of
the fleet collected samples, keep the value to \code{fleets=NULL}.}

\item{years}{*A list the same length as \code{fleets} giving the years as
numeric vectors. If no fleet collected samples, keep the value to
\code{years=NULL}.}

\item{sds_obs}{*A list the same length as \code{fleets}. The list should
contain either single values or numeric vectors of the same length as the
number of years which represent the standard deviation of the observation
error. Single values are repeated for all years.}

\item{make_plot}{A logical switch for whether to make a crude plot showing
the results. Useful for testing and exploring the function.}

\item{write_file}{A logical switch for whether to write \code{outfile} to
disk. Can be turned off to speed up testing or exploration of the
function. The new data are returned invisibly, as in the examples
below.}
}
\value{
A modified \code{.dat} file if \code{write_file=TRUE}. A list object
containing the modified \code{.dat} file is returned invisibly.
}
\description{
This function creates an index of abundance sampled from the expected
available biomass for given fleets in given years. Let B_y be the biomass
from the operating model for year y. Then the sampled value is calculated as:
B_y*exp(rnorm(1, 0, \code{sds_obs})-\code{sds_obs}^2/2). The second term
adjusts the random samples so that their expected value is B_y (i.e. the
log-normal bias correction).
If used with \code{\link{run_ss3sim}} the case file should be named
\code{index}. A suggested (default) case letter is \code{D} for data.
}
\section{Which arguments to specifiy in case files}{

All function argument descriptions that start with an asterisk (*) will be passed
through the case files to \code{\link{run_ss3sim}}. If one of these arguments
is not specified in a case file, then a value of \code{NULL} will be passed,
which may or may not be an appropriate value. Other arguments will be ignored
if specified.
}
\examples{
\dontrun{
# Find the example data location:
d <- system.file("extdata", package = "ss3sim")
f_in <- paste0(d, "/example-om/data.ss_new")
dat_list <- r4ss::SS_readdat(f_in, section = 2, verbose = FALSE)
dat_list <- change_fltname(dat_list)
outfile <- "test.dat"
ex1 <- sample_index(dat_list, outfile, fleets=c(2,3),
                    years=list(1938:2012, 1938:2012) ,
                    sds_obs=list(1e-6, 1e-6), write_file=FALSE,
                    make_plot = TRUE)
ex2 <- sample_index(dat_list, outfile, fleets=c(2,3),
                    years=list(1938:2012, 1938:2012) ,
                    sds_obs=list(.05, .05), write_file=FALSE,
                    make_plot = TRUE)
library(ggplot2)
ggplot(ex1, aes(x=year, y=obs, group=index, ymin=0,
                colour=as.factor(index)))+geom_line() + geom_point(data=ex2,
                aes(x=year, y=obs, colour=as.factor(index), group=index))
## Exclude a fleet and have varying sds_obs by year
ex3 <- sample_index(dat_list, outfile, fleets=c(2,NA),
                    years=list(1938:2012, 1950),
                    sds_obs=list(seq(.001, .1, len=75), .1),
                    write_file=FALSE)
ggplot(ex3, aes(x=year, y=obs, group=index, ymin=0,
                colour=as.factor(index)))+geom_point()
}
}
\author{
Cole Monnahan, Kotaro Ono
}
\seealso{
Other sampling functions: \code{\link{clean_data}},
  \code{\link{sample_agecomp}},
  \code{\link{sample_calcomp}}, \code{\link{sample_lcomp}},
  \code{\link{sample_mlacomp}},
  \code{\link{sample_wtatage}}
}

