% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions_application.R
\name{N_structure_gridbased}
\alias{N_structure_gridbased}
\title{Creates Grid-Based Neighborhood Structure}
\usage{
N_structure_gridbased(x, y, cutx, cuty)
}
\arguments{
\item{x}{vector of first coordinate of data set.}

\item{y}{vector of second coordinate of data set.}

\item{cutx}{cut-offs for first coordinate.}

\item{cuty}{cut-offs for second coordinate.}
}
\value{
Returns a neighborhood assignment vector for the coordinates \code{x} and \code{y}.
}
\description{
This function creates a grid-based neighborhood structure for the \code{\link[ssMRCD]{ssMRCD}} function using cut-off values for two coordinate axis.
}
\examples{
# get data
data(weatherAUT2021)

# set cut-off values
cut_lon = c(9:16, 18)
cut_lat = c(46, 47, 47.5, 48, 49)

# create neighborhood assignments
N_structure_gridbased(weatherAUT2021$lon,
                      weatherAUT2021$lat,
                      cut_lon,
                      cut_lat)
}
