% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prs.R
\name{prs.train}
\alias{prs.train}
\title{Polygenic risk score; training}
\usage{
prs.train(X0, X1)
}
\arguments{
\item{X0, X1}{n x p matrix of additively coded control and case genotypes, respectively; IMPORTANT: must be coded relative to the same allele in both cases and controls}
}
\value{
\item{pi0}{minor allele frequencies in controls}
\item{pi1}{minor allele frequencies in cases}
\item{P}{proportion of cases}
}
\description{
Equivalent to maximum likelihood naive Bayes classifier.
}
\examples{
p <- 1000; ## number of snps
I <- rep(0,p); I[1:10] <- 1; ## which snps are causal
set.seed(1); pi0 <- runif(p,0.1,0.5); ## control minor allele frequencies
set.seed(1); ors <- runif(sum(I),-1,1); ## odds ratios
pi1 <- pi0;
pi1[I==1] <- expit(ors+logit(pi0[I==1]));
n0 <- 100; ## number of controls
X0 <- t(replicate(n0,rbinom(p,2,pi0))); ## controls
n1 <- 50; ## number of cases
X1 <- t(replicate(n1,rbinom(p,2,pi1))); ## cases
prs.train(X0,X1);

}

