% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/burrIII2.R
\name{burrIII2}
\alias{burrIII2}
\alias{dburrIII2}
\alias{pburrIII2}
\alias{qburrIII2}
\alias{rburrIII2}
\alias{sburrIII2}
\title{Burr Type III Two-Parameter Distribution}
\usage{
dburrIII2(x, locationlog = 0, scalelog = 1, log = FALSE)

pburrIII2(q, locationlog = 0, scalelog = 1, lower.tail = TRUE, log.p = FALSE)

qburrIII2(p, locationlog = 0, scalelog = 1, lower.tail = TRUE, log.p = FALSE)

rburrIII2(n, locationlog = 0, scalelog = 1)

sburrIII2(x)
}
\arguments{
\item{x}{A numeric vector of values.}

\item{locationlog}{location on log scale parameter.}

\item{scalelog}{scale on log scale parameter.}

\item{log}{logical; if TRUE, probabilities p are given as log(p).}

\item{q}{vector of quantiles.}

\item{lower.tail}{logical; if TRUE (default), probabilities are \code{P[X <= x]},otherwise, \code{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\value{
A numeric vector.
}
\description{
Probability density, cumulative distribution,
inverse cumulative distribution, random sample and starting values functions.
}
\details{
The burrIII2 distribution has been deprecated for the identical llogis distribution.
}
\examples{
x <- seq(0.01, 5, by = 0.01)
plot(x, dburrIII2(x), type = "l")
}
\seealso{
\code{\link[=llogis]{llogis()}}
}
