% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/llog.R, R/llogis.R
\name{dllog}
\alias{dllog}
\alias{qllog}
\alias{pllog}
\alias{rllog}
\alias{sllog}
\alias{llogis}
\alias{dllogis}
\alias{pllogis}
\alias{qllogis}
\alias{rllogis}
\alias{sllogis}
\title{Log-Logistic Distribution}
\usage{
dllog(x, locationlog = 0, scalelog = 1, log = FALSE)

qllog(p, locationlog = 0, scalelog = 1, lower.tail = TRUE, log.p = FALSE)

pllog(q, locationlog = 0, scalelog = 1, lower.tail = TRUE, log.p = FALSE)

rllog(n, locationlog = 0, scalelog = 1)

sllog(x)

dllogis(x, locationlog = 0, scalelog = 1, log = FALSE)

pllogis(q, locationlog = 0, scalelog = 1, lower.tail = TRUE, log.p = FALSE)

qllogis(p, locationlog = 0, scalelog = 1, lower.tail = TRUE, log.p = FALSE)

rllogis(n, locationlog = 0, scalelog = 1)

sllogis(x)
}
\arguments{
\item{x}{A numeric vector of values.}

\item{locationlog}{location on log scale parameter.}

\item{scalelog}{scale on log scale parameter.}

\item{log}{logical; if TRUE, probabilities p are given as log(p).}

\item{p}{vector of probabilities.}

\item{lower.tail}{logical; if TRUE (default), probabilities are \code{P[X <= x]},otherwise, \code{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{q}{vector of quantiles.}

\item{n}{number of observations.}
}
\value{
A numeric vector.
}
\description{
Probability density, cumulative distribution,
inverse cumulative distribution, random sample and starting values functions.
}
\details{
The llog distribution has been deprecated for the identical llogis distribution.
}
\examples{
x <- seq(0.01, 5, by = 0.01)
plot(x, dllogis(x), type = "l")
}
\seealso{
\code{\link[stats:Logistic]{stats::dlogis()}}
}
