% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lnorm.R
\name{lnorm}
\alias{lnorm}
\alias{dlnorm}
\alias{plnorm}
\alias{qlnorm}
\alias{rlnorm}
\alias{slnorm}
\title{Log-Normal Distribution}
\usage{
dlnorm(x, meanlog = 0, sdlog = 1, log = FALSE)

plnorm(q, meanlog = 0, sdlog = 1, lower.tail = TRUE, log.p = FALSE)

qlnorm(p, meanlog = 0, sdlog = 1, lower.tail = TRUE, log.p = FALSE)

rlnorm(n, meanlog = 0, sdlog = 1)

slnorm(x)
}
\arguments{
\item{x}{A numeric vector of values.}

\item{meanlog}{mean on log scale parameter.}

\item{sdlog}{standard deviation on log scale parameter.}

\item{log}{logical; if TRUE, probabilities p are given as log(p).}

\item{q}{vector of quantiles.}

\item{lower.tail}{logical; if TRUE (default), probabilities are \code{P[X <= x]},otherwise, \code{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\value{
A numeric vector.
}
\description{
Probability density, cumulative distribution,
inverse cumulative distribution, random sample and starting values functions.
}
\examples{
x <- seq(0.01, 5, by = 0.01)
plot(x, dlnorm(x), type = "l")
}
\seealso{
\code{\link[stats:Lognormal]{stats::dlnorm()}}
}
